/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.browser.devtools;

import aquality.selenium.browser.devtools.DevToolsHandling;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.v85.dom.model.RGBA;
import org.openqa.selenium.devtools.v85.emulation.Emulation;
import org.openqa.selenium.devtools.v85.emulation.model.MediaFeature;
import org.openqa.selenium.devtools.v85.emulation.model.ScreenOrientation;

public class EmulationHandling {
    private final DevToolsHandling tools;

    public EmulationHandling(DevToolsHandling tools) {
        this.tools = tools;
    }

    public boolean canEmulate() {
        return (Boolean)this.tools.sendCommand(Emulation.canEmulate());
    }

    public void setGeolocationOverride(double latitude, double longitude, double accuracy) {
        this.setGeolocationOverride(Optional.of(latitude), Optional.of(longitude), Optional.of(accuracy));
    }

    public void setGeolocationOverride(double latitude, double longitude) {
        this.setGeolocationOverride(latitude, longitude, 1.0);
    }

    public void setGeolocationOverride(Optional<Number> latitude, Optional<Number> longitude, Optional<Number> accuracy) {
        this.tools.sendCommand(Emulation.setGeolocationOverride(latitude, longitude, accuracy));
    }

    public void clearGeolocationOverride() {
        this.tools.sendCommand(Emulation.clearGeolocationOverride());
    }

    public void setDeviceMetricsOverride(Map<String, Object> params) {
        this.tools.sendCommand(new Command("Emulation.setDeviceMetricsOverride", params));
    }

    public void setDeviceMetricsOverride(Integer width, Integer height, Number deviceScaleFactor, Boolean mobile) {
        this.setDeviceMetricsOverride(width, height, deviceScaleFactor, mobile, Optional.empty(), Optional.empty());
    }

    public void setDeviceMetricsOverride(Integer width, Integer height, Number deviceScaleFactor, Boolean mobile, Optional<String> screenOrientationType, Optional<Integer> screenOrientationAngle) {
        Optional<Object> screenOrientation = Optional.empty();
        if (screenOrientationType.isPresent() && StringUtils.isNotEmpty((CharSequence)screenOrientationType.get())) {
            Integer angle = 0;
            if (screenOrientationAngle.isPresent()) {
                angle = screenOrientationAngle.get();
            }
            screenOrientation = Optional.of(new ScreenOrientation(ScreenOrientation.Type.fromString((String)screenOrientationType.get()), angle));
        }
        this.tools.sendCommand(Emulation.setDeviceMetricsOverride((Integer)width, (Integer)height, (Number)deviceScaleFactor, (Boolean)mobile, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), screenOrientation, Optional.empty()));
    }

    public void clearDeviceMetricsOverride() {
        this.tools.sendCommand(Emulation.clearDeviceMetricsOverride());
    }

    public void setUserAgentOverride(Map<String, Object> params) {
        this.tools.sendCommand(new Command("Emulation.setUserAgentOverride", params));
    }

    public void setUserAgentOverride(String userAgent) {
        this.setUserAgentOverride(userAgent, Optional.empty(), Optional.empty());
    }

    public void setUserAgentOverride(String userAgent, Optional<String> acceptLanguage, Optional<String> platform) {
        this.tools.sendCommand(Emulation.setUserAgentOverride((String)userAgent, acceptLanguage, platform, Optional.empty()));
    }

    public void setScriptExecutionDisabled() {
        this.setScriptExecutionDisabled(true);
    }

    public void setScriptExecutionDisabled(boolean value) {
        this.tools.sendCommand(Emulation.setScriptExecutionDisabled((Boolean)value));
    }

    public void setTouchEmulationEnabled() {
        this.setTouchEmulationEnabled(true);
    }

    public void setTouchEmulationEnabled(boolean enabled) {
        this.setTouchEmulationEnabled(enabled, Optional.empty());
    }

    public void setTouchEmulationEnabled(boolean enabled, Optional<Integer> maxTouchPoints) {
        this.tools.sendCommand(Emulation.setTouchEmulationEnabled((Boolean)enabled, maxTouchPoints));
    }

    public void setEmulatedMedia(Map<String, Object> params) {
        this.tools.sendCommand(new Command("Emulation.setEmulatedMedia", params));
    }

    public void setEmulatedMedia(String media, Map<String, String> mediaFeatures) {
        this.setEmulatedMedia(Optional.of(media), Optional.of(mediaFeatures));
    }

    public void setEmulatedMedia(Optional<String> media, Optional<Map<String, String>> mediaFeatures) {
        List featureList = mediaFeatures.orElse(Collections.emptyMap()).entrySet().stream().map(entry -> new MediaFeature((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
        this.tools.sendCommand(Emulation.setEmulatedMedia(media, Optional.of(featureList)));
    }

    public void disableEmulatedMediaOverride() {
        this.setEmulatedMedia(Collections.singletonMap("media", ""));
    }

    public void setDefaultBackgroundColorOverride(int red, int green, int blue) {
        this.setDefaultBackgroundColorOverride(red, green, blue, Optional.empty());
    }

    public void setDefaultBackgroundColorOverride(int red, int green, int blue, Optional<Number> alpha) {
        this.tools.sendCommand(Emulation.setDefaultBackgroundColorOverride(Optional.of(new RGBA(Integer.valueOf(red), Integer.valueOf(green), Integer.valueOf(blue), alpha))));
    }

    public void clearDefaultBackgroundColorOverride() {
        this.tools.sendCommand(Emulation.setDefaultBackgroundColorOverride(Optional.empty()));
    }
}

