/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.browser.devtools;

import aquality.selenium.browser.AqualityServices;
import aquality.selenium.browser.devtools.EmulationHandling;
import aquality.selenium.browser.devtools.JavaScriptHandling;
import aquality.selenium.browser.devtools.NetworkHandling;
import aquality.selenium.core.localization.ILocalizedLogger;
import aquality.selenium.logging.DevToolsCommandLoggingOptions;
import aquality.selenium.logging.LocalizedLoggerUtility;
import aquality.selenium.logging.LoggingParameters;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.openqa.selenium.chromium.ChromiumDriver;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.devtools.v85.performance.Performance;
import org.openqa.selenium.devtools.v85.performance.model.Metric;

public class DevToolsHandling {
    private final HasDevTools devToolsProvider;
    private final ILocalizedLogger logger;
    private DevTools session;
    private NetworkHandling network;
    private EmulationHandling emulation;
    private JavaScriptHandling javaScript;

    public DevToolsHandling(HasDevTools devToolsProvider) {
        this.devToolsProvider = devToolsProvider;
        this.logger = AqualityServices.getLocalizedLogger();
    }

    HasDevTools getDevToolsProvider() {
        return this.devToolsProvider;
    }

    private DevTools getDevTools() {
        return this.getDevTools("default");
    }

    private DevTools getDevTools(String handleToLog) {
        if (this.session == null) {
            this.logger.info("loc.browser.devtools.session.get", new Object[]{handleToLog});
            this.session = this.devToolsProvider.getDevTools();
        }
        return this.session;
    }

    private void logCommand(String commandName, Map<String, Object> commandParameters, DevToolsCommandLoggingOptions loggingOptions) {
        LoggingParameters logging = (loggingOptions == null ? new DevToolsCommandLoggingOptions() : loggingOptions).getCommand();
        if (!logging.isEnabled()) {
            return;
        }
        if (!commandParameters.isEmpty()) {
            LocalizedLoggerUtility.logByLevel(logging.getLogLevel(), "loc.browser.devtools.command.execute.withparams", commandName, commandParameters);
        } else {
            LocalizedLoggerUtility.logByLevel(logging.getLogLevel(), "loc.browser.devtools.command.execute", commandName);
        }
    }

    private void logCommandResult(Object result, DevToolsCommandLoggingOptions loggingOptions) {
        LoggingParameters logging = (loggingOptions == null ? new DevToolsCommandLoggingOptions() : loggingOptions).getCommand();
        if (result != null && logging.isEnabled()) {
            if (result instanceof Map && ((Map)result).isEmpty()) {
                return;
            }
            LocalizedLoggerUtility.logByLevel(logging.getLogLevel(), "loc.browser.devtools.command.execute.result", result);
        }
    }

    public DevTools getDevToolsSession() {
        this.getDevTools().createSessionIfThereIsNotOne();
        return this.session;
    }

    public DevTools getDevToolsSession(String windowHandle) {
        this.getDevTools(windowHandle).createSessionIfThereIsNotOne(windowHandle);
        return this.session;
    }

    public boolean hasActiveDevToolsSession() {
        this.logger.info("loc.browser.devtools.session.isactive", new Object[0]);
        boolean result = this.devToolsProvider.getDevTools().getCdpSession() != null;
        this.logger.info("loc.browser.devtools.session.isactive.result", new Object[]{result});
        return result;
    }

    public void closeDevToolsSession() {
        this.logger.info("loc.browser.devtools.session.close", new Object[0]);
        this.getDevTools().disconnectSession();
    }

    public Map<String, Object> executeCdpCommand(String commandName, Map<String, Object> commandParameters) {
        return this.executeCdpCommand(commandName, commandParameters, null);
    }

    public Map<String, Object> executeCdpCommand(String commandName, Map<String, Object> commandParameters, DevToolsCommandLoggingOptions loggingOptions) {
        if (this.devToolsProvider instanceof ChromiumDriver) {
            this.logCommand(commandName, commandParameters, loggingOptions);
            ChromiumDriver driver = (ChromiumDriver)this.devToolsProvider;
            Map result = driver.executeCdpCommand(commandName, commandParameters);
            this.logCommandResult(result, loggingOptions);
            return result;
        }
        throw new UnsupportedOperationException("Execution of CDP command directly is not supported for current browser. Try sendCommand method instead.");
    }

    public <X> X sendCommand(Command<X> command) {
        return this.sendCommand(command, null);
    }

    public <X> X sendCommand(Command<X> command, DevToolsCommandLoggingOptions loggingOptions) {
        this.logCommand(command.getMethod(), command.getParams(), loggingOptions);
        Object result = this.getDevToolsSession().send(command);
        this.logCommandResult(result, loggingOptions);
        return (X)result;
    }

    public <X> void addListener(Event<X> event, Consumer<X> handler) {
        this.logger.info("loc.browser.devtools.listener.add", new Object[]{event.getMethod()});
        this.getDevToolsSession().addListener(event, handler);
    }

    public void clearListeners() {
        this.logger.info("loc.browser.devtools.listener.clear", new Object[0]);
        this.getDevToolsSession().clearListeners();
    }

    public EmulationHandling emulation() {
        if (this.emulation == null) {
            this.emulation = new EmulationHandling(this);
        }
        return this.emulation;
    }

    public NetworkHandling network() {
        if (this.network == null) {
            this.network = new NetworkHandling(this);
        }
        return this.network;
    }

    public JavaScriptHandling javaScript() {
        if (this.javaScript == null) {
            this.javaScript = new JavaScriptHandling(this);
        }
        return this.javaScript;
    }

    public void disablePerformanceMonitoring() {
        this.sendCommand(Performance.disable());
    }

    public void enablePerformanceMonitoring(String timeDomain) {
        this.sendCommand(Performance.enable(Optional.of(Performance.EnableTimeDomain.fromString((String)timeDomain))));
    }

    public void enablePerformanceMonitoring() {
        this.sendCommand(Performance.enable(Optional.empty()));
    }

    public Map<String, Number> getPerformanceMetrics() {
        Command command = Performance.getMetrics();
        this.logCommand(command.getMethod(), command.getParams(), null);
        List metrics = (List)this.getDevToolsSession().send(command);
        Map<String, Number> result = metrics.stream().collect(Collectors.toMap(Metric::getName, Metric::getValue));
        this.logCommandResult(result.isEmpty() ? "empty" : result, null);
        return result;
    }
}

