/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.browser;

import aquality.selenium.browser.BrowserFactory;
import aquality.selenium.configuration.IBrowserProfile;
import aquality.selenium.configuration.ITimeoutConfiguration;
import aquality.selenium.core.localization.ILocalizedLogger;
import aquality.selenium.core.utilities.IActionRetrier;
import com.google.common.collect.ImmutableMap;
import java.net.URL;
import java.time.Duration;
import java.util.Map;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.AbstractDriverOptions;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.LocalFileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.HttpClient;

public class RemoteBrowserFactory
extends BrowserFactory {
    private final IBrowserProfile browserProfile;
    private final ITimeoutConfiguration timeoutConfiguration;
    private final ILocalizedLogger localizedLogger;

    public RemoteBrowserFactory(IActionRetrier actionRetrier, IBrowserProfile browserProfile, ITimeoutConfiguration timeoutConfiguration, ILocalizedLogger localizedLogger) {
        super(actionRetrier, browserProfile, localizedLogger);
        this.browserProfile = browserProfile;
        this.timeoutConfiguration = timeoutConfiguration;
        this.localizedLogger = localizedLogger;
    }

    @Override
    protected RemoteWebDriver getDriver() {
        AbstractDriverOptions<?> capabilities = this.browserProfile.getDriverSettings().getDriverOptions();
        this.localizedLogger.info("loc.browser.grid", new Object[0]);
        ClientFactory clientFactory = new ClientFactory();
        HttpCommandExecutor commandExecutor = new HttpCommandExecutor((Map)ImmutableMap.of(), this.browserProfile.getRemoteConnectionUrl(), (HttpClient.Factory)clientFactory);
        try {
            RemoteWebDriver driver = new RemoteWebDriver((CommandExecutor)commandExecutor, capabilities);
            driver.setFileDetector((FileDetector)new LocalFileDetector());
            return driver;
        }
        catch (WebDriverException e) {
            this.localizedLogger.fatal("loc.browser.grid.fail", (Throwable)e, new Object[0]);
            throw e;
        }
    }

    static /* synthetic */ ITimeoutConfiguration access$000(RemoteBrowserFactory x0) {
        return x0.timeoutConfiguration;
    }

    class ClientFactory
    implements HttpClient.Factory {
        private final HttpClient.Factory defaultClientFactory = HttpClient.Factory.createDefault();
        private final Duration timeoutCommand = RemoteBrowserFactory.access$000(RemoteBrowserFactory.this).getCommand();

        ClientFactory() {
        }

        public HttpClient createClient(URL url) {
            return this.defaultClientFactory.createClient(ClientConfig.defaultConfig().baseUrl(url).readTimeout(this.timeoutCommand));
        }

        public HttpClient createClient(ClientConfig clientConfig) {
            clientConfig.readTimeout(this.timeoutCommand);
            return this.defaultClientFactory.createClient(clientConfig);
        }

        public void cleanupIdleClients() {
            this.defaultClientFactory.cleanupIdleClients();
        }
    }
}

