/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.browser;

import aquality.selenium.core.logging.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.logging.log4j.core.util.IOUtils;

public enum JavaScript {
    AUTO_ACCEPT_ALERTS("autoAcceptAlerts.js"),
    BORDER_ELEMENT("borderElement.js"),
    CLICK_ELEMENT("clickElement.js"),
    ELEMENT_IS_ON_SCREEN("elementIsOnScreen.js"),
    GET_CHECKBOX_STATE("getCheckBxState.js"),
    GET_COMBOBOX_SELECTED_TEXT("getCmbText.js"),
    GET_COMBOBOX_TEXTS("getCmbValues.js"),
    GET_DEVICE_PIXEL_RATIO("getDevicePixelRatio.js"),
    GET_ELEMENT_BY_XPATH("getElementByXpath.js"),
    GET_ELEMENTS_FROM_POINT("getElementsFromPoint.js"),
    GET_ELEMENT_CSS_SELECTOR("getElementCssSelector.js"),
    GET_ELEMENT_XPATH("getElementXPath.js"),
    GET_ELEMENT_TEXT("getElementText.js"),
    GET_TEXT_FIRST_CHILD("getTextFirstChild.js"),
    MOUSE_HOVER("mouseHover.js"),
    SCROLL_TO_BOTTOM("scrollToBottom.js"),
    SCROLL_TO_ELEMENT("scrollToElement.js"),
    SCROLL_TO_ELEMENT_CENTER("scrollToElementCenter.js"),
    SCROLL_TO_TOP("scrollToTop.js"),
    SELECT_COMBOBOX_VALUE_BY_TEXT("selectComboboxValueByText.js"),
    SET_FOCUS("setFocus.js"),
    SET_VALUE("setValue.js"),
    SET_ATTRIBUTE("setAttribute.js"),
    SCROLL_BY("scrollBy.js"),
    IS_PAGE_LOADED("isPageLoaded.js"),
    SCROLL_WINDOW_BY("scrollWindowBy.js"),
    SET_INNER_HTML("setInnerHTML.js"),
    GET_VIEWPORT_COORDINATES("getViewPortCoordinates.js"),
    GET_SCREEN_OFFSET("getScreenOffset.js"),
    OPEN_IN_NEW_TAB("openInNewTab.js"),
    OPEN_NEW_TAB("openNewTab.js"),
    EXPAND_SHADOW_ROOT("expandShadowRoot.js");

    private final String filename;

    private JavaScript(String filename) {
        this.filename = filename;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getScript() {
        URL scriptFile = ((Object)((Object)this)).getClass().getResource("/js/" + this.filename);
        if (scriptFile == null) return "";
        try (InputStream stream = scriptFile.openStream();){
            String string = JavaScript.readScript(stream);
            return string;
        }
        catch (IOException e) {
            JavaScript.logScriptAbsence(this.filename, e);
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String readScript(File file) {
        try (InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            String string = JavaScript.readScript(stream);
            return string;
        }
        catch (IOException e) {
            JavaScript.logScriptAbsence(file.getName(), e);
            return "";
        }
    }

    private static void logScriptAbsence(String filename, IOException e) {
        Logger.getInstance().fatal(String.format("Couldn't find the script \"%s\"", filename), (Throwable)e);
    }

    private static String readScript(InputStream stream) throws IOException {
        return IOUtils.toString((Reader)new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8)));
    }
}

