/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.browser;

import aquality.selenium.browser.IBrowserTabNavigation;
import aquality.selenium.browser.JavaScript;
import aquality.selenium.core.localization.ILocalizedLogger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import org.openqa.selenium.WindowType;
import org.openqa.selenium.remote.RemoteWebDriver;

public class BrowserTabNavigation
implements IBrowserTabNavigation {
    private final RemoteWebDriver driver;
    private final ILocalizedLogger logger;

    protected BrowserTabNavigation(RemoteWebDriver driver, ILocalizedLogger logger) {
        this.driver = driver;
        this.logger = logger;
    }

    @Override
    public String getCurrentTabHandle() {
        this.logger.info("loc.browser.get.tab.handle", new Object[0]);
        return this.driver.getWindowHandle();
    }

    @Override
    public Set<String> getTabHandles() {
        this.logger.info("loc.browser.get.tab.handles", new Object[0]);
        return this.driver.getWindowHandles();
    }

    @Override
    public void switchToTab(String tabHandle, boolean closeCurrent) {
        this.logger.info("loc.browser.switch.to.tab.handle", new Object[]{tabHandle});
        this.closeAndSwitch(tabHandle, closeCurrent);
    }

    @Override
    public void switchToTab(int index, boolean closeCurrent) {
        this.logger.info("loc.browser.switch.to.tab.index", new Object[]{index});
        ArrayList<String> handles = new ArrayList<String>(this.getTabHandles());
        if (index < 0 || handles.size() <= index) {
            throw new IndexOutOfBoundsException(String.format("Index of browser tab '%1$s' you provided is out of range 0..%2$s", index, handles.size()));
        }
        String newTab = (String)handles.get(index);
        this.closeAndSwitch(newTab, closeCurrent);
    }

    @Override
    public void switchToLastTab(boolean closeCurrent) {
        this.logger.info("loc.browser.switch.to.new.tab", new Object[0]);
        ArrayList<String> handles = new ArrayList<String>(this.getTabHandles());
        this.closeAndSwitch((String)handles.get(handles.size() - 1), closeCurrent);
    }

    @Override
    public void closeTab() {
        this.logger.info("loc.browser.tab.close", new Object[0]);
        this.driver.close();
    }

    @Override
    public void openNewTab(boolean switchToNew) {
        this.logger.info("loc.browser.tab.open.new", new Object[0]);
        String currentHandle = switchToNew ? null : this.getCurrentTabHandle();
        this.driver.switchTo().newWindow(WindowType.TAB);
        if (!switchToNew) {
            this.closeAndSwitch(currentHandle, false);
        }
    }

    @Override
    public void openNewTabViaJs(boolean switchToNew) {
        this.logger.info("loc.browser.tab.open.new", new Object[0]);
        this.driver.executeScript(JavaScript.OPEN_NEW_TAB.getScript(), new Object[0]);
        if (switchToNew) {
            this.switchToLastTab();
        }
    }

    @Override
    public void openInNewTab(String url) {
        this.openNewTab();
        this.driver.navigate().to(url);
    }

    @Override
    public void openInNewTab(URL url) {
        this.driver.switchTo().newWindow(WindowType.TAB);
        this.driver.navigate().to(url);
    }

    @Override
    public void openInNewTabViaJs(String url) {
        this.driver.executeScript(JavaScript.OPEN_IN_NEW_TAB.getScript(), new Object[]{url});
    }

    private void closeAndSwitch(String name, boolean closeCurrent) {
        if (closeCurrent) {
            this.closeTab();
        }
        this.driver.switchTo().window(name);
    }
}

