/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.browser;

import aquality.selenium.browser.Browser;
import aquality.selenium.browser.IBrowserFactory;
import aquality.selenium.configuration.IBrowserProfile;
import aquality.selenium.core.localization.ILocalizedLogger;
import aquality.selenium.core.utilities.IActionRetrier;
import java.util.Arrays;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.UnreachableBrowserException;

public abstract class BrowserFactory
implements IBrowserFactory {
    private final IActionRetrier actionRetrier;
    private final IBrowserProfile browserProfile;
    private final ILocalizedLogger localizedLogger;

    protected BrowserFactory(IActionRetrier actionRetrier, IBrowserProfile browserProfile, ILocalizedLogger localizedLogger) {
        this.actionRetrier = actionRetrier;
        this.browserProfile = browserProfile;
        this.localizedLogger = localizedLogger;
    }

    protected abstract RemoteWebDriver getDriver();

    @Override
    public Browser getBrowser() {
        RemoteWebDriver driver = (RemoteWebDriver)this.actionRetrier.doWithRetry(this::getDriver, Arrays.asList(SessionNotCreatedException.class, UnreachableBrowserException.class, WebDriverException.class, TimeoutException.class));
        Browser browser = new Browser(driver);
        this.localizedLogger.info("loc.browser.ready", new Object[]{this.browserProfile.getBrowserName().toString()});
        return browser;
    }
}

