/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.browser;

import aquality.selenium.browser.AlertActions;
import aquality.selenium.browser.AqualityServices;
import aquality.selenium.browser.BrowserName;
import aquality.selenium.browser.BrowserNavigation;
import aquality.selenium.browser.BrowserTabNavigation;
import aquality.selenium.browser.IBrowserTabNavigation;
import aquality.selenium.browser.JavaScript;
import aquality.selenium.browser.devtools.DevToolsHandling;
import aquality.selenium.browser.devtools.JavaScriptHandling;
import aquality.selenium.browser.devtools.NetworkHandling;
import aquality.selenium.configuration.IBrowserProfile;
import aquality.selenium.configuration.ITimeoutConfiguration;
import aquality.selenium.core.applications.IApplication;
import aquality.selenium.core.localization.ILocalizationManager;
import aquality.selenium.core.localization.ILocalizedLogger;
import aquality.selenium.core.waitings.IConditionalWait;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.function.Supplier;
import org.openqa.selenium.Alert;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.ScriptKey;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;

public class Browser
implements IApplication {
    private final RemoteWebDriver webDriver;
    private final ITimeoutConfiguration timeouts;
    private final IBrowserProfile browserProfile;
    private final IConditionalWait conditionalWait = AqualityServices.getConditionalWait();
    private final ILocalizationManager localizationManager = AqualityServices.get(ILocalizationManager.class);
    private final ILocalizedLogger localizedLogger = AqualityServices.getLocalizedLogger();
    private DevToolsHandling devTools;
    private Duration implicitTimeout;

    public Browser(RemoteWebDriver remoteWebDriver) {
        this.browserProfile = AqualityServices.getBrowserProfile();
        this.timeouts = AqualityServices.get(ITimeoutConfiguration.class);
        this.webDriver = remoteWebDriver;
        this.implicitTimeout = this.timeouts.getImplicit();
        this.getDriver().manage().timeouts().implicitlyWait(this.implicitTimeout);
        this.setPageLoadTimeout(this.timeouts.getPageLoad());
        this.setScriptTimeout(this.timeouts.getScript());
    }

    public void quit() {
        this.localizedLogger.info("loc.browser.driver.quit", new Object[0]);
        if (this.getDriver() != null) {
            this.getDriver().quit();
        }
    }

    public RemoteWebDriver getDriver() {
        return this.webDriver;
    }

    public boolean isStarted() {
        return this.webDriver.getSessionId() != null;
    }

    public void goTo(String url) {
        this.navigate().to(url);
    }

    public void goBack() {
        this.navigate().back();
    }

    public void goForward() {
        this.navigate().forward();
    }

    public void maximize() {
        this.localizedLogger.info("loc.browser.maximize", new Object[0]);
        this.getDriver().manage().window().maximize();
    }

    public String getCurrentUrl() {
        this.localizedLogger.info("loc.browser.getUrl", new Object[0]);
        String value = this.getDriver().getCurrentUrl();
        this.localizedLogger.info("loc.browser.url.value", new Object[]{value});
        return value;
    }

    public void refresh() {
        this.navigate().refresh();
    }

    public void refreshPageWithAlert(AlertActions alertAction) {
        this.refresh();
        this.handleAlert(alertAction);
    }

    private WebDriver.Navigation navigate() {
        return new BrowserNavigation(this.getDriver(), this.localizedLogger);
    }

    public IBrowserTabNavigation tabs() {
        return new BrowserTabNavigation(this.getDriver(), this.localizedLogger);
    }

    public void setPageLoadTimeout(Duration timeout) {
        if (!this.getBrowserName().equals((Object)BrowserName.SAFARI)) {
            this.localizedLogger.debug("loc.browser.page.load.timeout", new Object[]{timeout.getSeconds()});
            this.getDriver().manage().timeouts().pageLoadTimeout(timeout);
        }
    }

    public void setImplicitWaitTimeout(Duration timeout) {
        if (!timeout.equals(this.getImplicitWaitTimeout())) {
            this.localizedLogger.debug("loc.browser.implicit.timeout", new Object[]{timeout.getSeconds()});
            this.getDriver().manage().timeouts().implicitlyWait(timeout);
            this.implicitTimeout = timeout;
        }
    }

    public void setScriptTimeout(Duration timeout) {
        this.localizedLogger.debug("loc.browser.script.timeout", new Object[]{timeout.getSeconds()});
        this.getDriver().manage().timeouts().scriptTimeout(timeout);
    }

    public void waitForPageToLoad() {
        this.localizedLogger.info("loc.browser.page.wait", new Object[0]);
        ExpectedCondition condition = d -> {
            Object result = this.executeScript(JavaScript.IS_PAGE_LOADED.getScript(), new Object[0]);
            return result instanceof Boolean && (Boolean)result != false;
        };
        this.conditionalWait.waitFor(condition, this.timeouts.getPageLoad(), this.timeouts.getPollingInterval(), this.localizationManager.getLocalizedMessage("loc.browser.page.timeout", new Object[0]));
    }

    public byte[] getScreenshot() {
        return (byte[])this.getDriver().getScreenshotAs(OutputType.BYTES);
    }

    public LogEntries getLogs(String logKind) {
        return this.getDriver().manage().logs().get(logKind);
    }

    public Object executeAsyncScript(String script, Object ... arguments) {
        return this.executeJavaScript(() -> this.getDriver().executeAsyncScript(script, arguments));
    }

    public Object executeAsyncScript(JavaScript scriptName, Object ... args) {
        return this.executeAsyncScript(scriptName.getScript(), args);
    }

    public Object executeAsyncScript(File file, Object ... arguments) {
        return this.executeAsyncScript(JavaScript.readScript(file), arguments);
    }

    public Object executeScript(String script, Object ... arguments) {
        return this.executeJavaScript(() -> this.getDriver().executeScript(script, arguments));
    }

    public Object executeScript(ScriptKey script, Object ... arguments) {
        return this.executeJavaScript(() -> this.getDriver().executeScript(script, arguments));
    }

    private Object executeJavaScript(Supplier<Object> executeScriptFunc) {
        Object result = executeScriptFunc.get();
        return result instanceof Boolean ? Boolean.valueOf(Boolean.parseBoolean(result.toString())) : result;
    }

    public Object executeScript(JavaScript scriptName, Object ... args) {
        return this.executeScript(scriptName.getScript(), args);
    }

    public Object executeScript(File file, Object ... arguments) throws IOException {
        return this.executeScript(JavaScript.readScript(file), arguments);
    }

    public void handleAlert(AlertActions alertAction) {
        this.handlePromptAlert(alertAction, null);
    }

    public void handlePromptAlert(AlertActions alertAction, String text) {
        this.localizedLogger.info(String.format("loc.browser.alert.%s", alertAction.name().toLowerCase()), new Object[0]);
        try {
            Alert alert = this.getDriver().switchTo().alert();
            if (text != null && !text.isEmpty()) {
                this.localizedLogger.info("loc.send.text", new Object[]{text});
                this.getDriver().switchTo().alert().sendKeys(text);
            }
            if (alertAction.equals((Object)AlertActions.ACCEPT)) {
                alert.accept();
            } else {
                alert.dismiss();
            }
        }
        catch (NoAlertPresentException exception) {
            this.localizedLogger.fatal("loc.browser.alert.fail", (Throwable)exception, new Object[0]);
            throw exception;
        }
    }

    public void scrollWindowBy(int x, int y) {
        this.executeScript(JavaScript.SCROLL_WINDOW_BY.getScript(), x, y);
    }

    public void setWindowSize(int width, int height) {
        this.getDriver().manage().window().setSize(new Dimension(width, height));
    }

    public String getDownloadDirectory() {
        return this.browserProfile.getDriverSettings().getDownloadDir();
    }

    public final BrowserName getBrowserName() {
        return this.browserProfile.getBrowserName();
    }

    private Duration getImplicitWaitTimeout() {
        return this.implicitTimeout;
    }

    public DevToolsHandling devTools() {
        if (this.devTools != null) {
            return this.devTools;
        }
        RemoteWebDriver driver = this.getDriver();
        if (!(driver instanceof HasDevTools)) {
            driver = new Augmenter().augment((WebDriver)driver);
        }
        if (driver instanceof HasDevTools) {
            this.devTools = new DevToolsHandling((HasDevTools)driver);
            return this.devTools;
        }
        throw new UnsupportedOperationException("DevTools protocol is not supported for current browser.");
    }

    public NetworkHandling network() {
        return this.devTools().network();
    }

    public JavaScriptHandling javaScriptEngine() {
        return this.devTools().javaScript();
    }
}

