/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.browser;

import aquality.selenium.browser.Browser;
import aquality.selenium.browser.BrowserFactory;
import aquality.selenium.browser.BrowserModule;
import aquality.selenium.browser.IBrowserFactory;
import aquality.selenium.browser.LocalBrowserFactory;
import aquality.selenium.browser.RemoteBrowserFactory;
import aquality.selenium.configuration.IBrowserProfile;
import aquality.selenium.configuration.IConfiguration;
import aquality.selenium.configuration.ITimeoutConfiguration;
import aquality.selenium.core.localization.ILocalizedLogger;
import aquality.selenium.core.logging.Logger;
import aquality.selenium.core.utilities.IActionRetrier;
import aquality.selenium.core.waitings.IConditionalWait;
import aquality.selenium.elements.interfaces.IElementFactory;
import com.google.inject.Injector;
import com.google.inject.Provider;

public class AqualityServices
extends aquality.selenium.core.applications.AqualityServices<Browser> {
    private static final ThreadLocal<AqualityServices> INSTANCE_CONTAINER = ThreadLocal.withInitial(AqualityServices::new);
    private IBrowserFactory browserFactory;

    private AqualityServices() {
        super(AqualityServices::getBrowser, () -> new BrowserModule((Provider<Browser>)((Provider)AqualityServices::getBrowser)));
    }

    private AqualityServices(BrowserModule module) {
        super(AqualityServices::getBrowser, () -> module);
    }

    private static AqualityServices getInstance() {
        return INSTANCE_CONTAINER.get();
    }

    public static Browser getBrowser() {
        return (Browser)AqualityServices.getInstance().getApp(injector -> AqualityServices.startBrowser());
    }

    public static boolean isBrowserStarted() {
        return AqualityServices.getInstance().isAppStarted();
    }

    public static <T> T get(Class<T> type) {
        return (T)AqualityServices.getServiceProvider().getInstance(type);
    }

    private static Injector getServiceProvider() {
        return AqualityServices.getInstance().getInjector();
    }

    public static void setDefaultBrowserFactory() {
        BrowserFactory browserFactory = AqualityServices.getBrowserProfile().isRemote() ? new RemoteBrowserFactory(AqualityServices.get(IActionRetrier.class), AqualityServices.getBrowserProfile(), AqualityServices.get(ITimeoutConfiguration.class), AqualityServices.getLocalizedLogger()) : new LocalBrowserFactory(AqualityServices.get(IActionRetrier.class), AqualityServices.getBrowserProfile(), AqualityServices.getLocalizedLogger());
        AqualityServices.setBrowserFactory(browserFactory);
    }

    public static IBrowserFactory getBrowserFactory() {
        if (AqualityServices.getInstance().browserFactory == null) {
            AqualityServices.setDefaultBrowserFactory();
        }
        return AqualityServices.getInstance().browserFactory;
    }

    public static void setBrowserFactory(IBrowserFactory browserFactory) {
        AqualityServices.getInstance().browserFactory = browserFactory;
    }

    private static Browser startBrowser() {
        return AqualityServices.getBrowserFactory().getBrowser();
    }

    public static void setBrowser(Browser browser) {
        AqualityServices.getInstance().setApp(browser);
    }

    public static void initInjector(BrowserModule module) {
        if (INSTANCE_CONTAINER.get() != null) {
            INSTANCE_CONTAINER.remove();
        }
        INSTANCE_CONTAINER.set(new AqualityServices(module));
    }

    public static Logger getLogger() {
        return AqualityServices.get(Logger.class);
    }

    public static ILocalizedLogger getLocalizedLogger() {
        return AqualityServices.get(ILocalizedLogger.class);
    }

    public static IConditionalWait getConditionalWait() {
        return AqualityServices.get(IConditionalWait.class);
    }

    public static IElementFactory getElementFactory() {
        return AqualityServices.get(IElementFactory.class);
    }

    public static IBrowserProfile getBrowserProfile() {
        return AqualityServices.get(IBrowserProfile.class);
    }

    public static IConfiguration getConfiguration() {
        return AqualityServices.get(IConfiguration.class);
    }
}

