/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.core.waitings;

import aquality.selenium.core.applications.IApplication;
import aquality.selenium.core.configurations.ITimeoutConfiguration;
import aquality.selenium.core.waitings.IConditionalWait;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.function.BooleanSupplier;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;

public class ConditionalWait
implements IConditionalWait {
    private final Provider<IApplication> applicationProvider;
    private final ITimeoutConfiguration timeoutConfiguration;

    @Inject
    public ConditionalWait(Provider<IApplication> applicationProvider, ITimeoutConfiguration timeoutConfiguration) {
        this.applicationProvider = applicationProvider;
        this.timeoutConfiguration = timeoutConfiguration;
    }

    @Override
    public boolean waitFor(BooleanSupplier condition, Duration timeout, Duration pollingInterval, String message, Collection<Class<? extends Throwable>> exceptionsToIgnore) {
        try {
            this.waitForTrue(condition, timeout, pollingInterval, message, exceptionsToIgnore);
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    @Override
    public void waitForTrue(BooleanSupplier condition, Duration timeout, Duration pollingInterval, String message, Collection<Class<? extends Throwable>> exceptionsToIgnore) throws TimeoutException {
        BooleanSupplier supplier = Optional.ofNullable(condition).orElseThrow(() -> new IllegalArgumentException("Condition cannot be null"));
        long timeoutInSeconds = this.resolveConditionTimeoutInSeconds(timeout);
        long pollingIntervalInMilliseconds = this.resolvePollingInterval(pollingInterval).toMillis();
        String exMessage = this.resolveMessage(message);
        double startTime = this.getCurrentTime();
        while (!this.isConditionSatisfied(supplier, exceptionsToIgnore)) {
            double currentTime = this.getCurrentTime();
            if (currentTime - startTime > (double)timeoutInSeconds) {
                String exceptionMessage = String.format("Timed out after %1$s seconds during wait for condition '%2$s'", timeoutInSeconds, exMessage);
                throw new TimeoutException(exceptionMessage);
            }
            try {
                Thread.sleep(pollingIntervalInMilliseconds);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T waitFor(ExpectedCondition<T> condition, Duration timeout, Duration pollingInterval, String message, Collection<Class<? extends Throwable>> exceptionsToIgnore) {
        IApplication app = (IApplication)this.applicationProvider.get();
        app.setImplicitWaitTimeout(Duration.ZERO);
        long timeoutInSeconds = this.resolveConditionTimeoutInSeconds(timeout);
        Duration actualPollingInterval = this.resolvePollingInterval(pollingInterval);
        String exMessage = this.resolveMessage(message);
        WebDriverWait wait = new WebDriverWait((WebDriver)app.getDriver(), timeoutInSeconds);
        wait.pollingEvery(actualPollingInterval);
        wait.withMessage(exMessage);
        wait.ignoreAll(exceptionsToIgnore == null ? Collections.singleton(StaleElementReferenceException.class) : exceptionsToIgnore);
        try {
            Object object = wait.until(condition);
            return (T)object;
        }
        finally {
            app.setImplicitWaitTimeout(this.timeoutConfiguration.getImplicit());
        }
    }

    private double getCurrentTime() {
        return (double)System.nanoTime() / Math.pow(10.0, 9.0);
    }

    private boolean isConditionSatisfied(BooleanSupplier condition, Collection<Class<? extends Throwable>> exceptionsToIgnore) {
        try {
            return condition.getAsBoolean();
        }
        catch (Exception e) {
            if (exceptionsToIgnore == null || !exceptionsToIgnore.contains(e.getClass())) {
                throw e;
            }
            return false;
        }
    }

    private long resolveConditionTimeoutInSeconds(Duration timeout) {
        return Optional.ofNullable(timeout).orElse(this.timeoutConfiguration.getCondition()).getSeconds();
    }

    private Duration resolvePollingInterval(Duration pollingInterval) {
        return Optional.ofNullable(pollingInterval).orElse(this.timeoutConfiguration.getPollingInterval());
    }

    private String resolveMessage(String message) {
        return Strings.isNullOrEmpty((String)message) ? "" : message;
    }
}

