/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.core.utilities;

import aquality.selenium.core.utilities.JsonSettingsFile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.stream.Collectors;

class ResourceFile {
    private final String resourceName;
    private final String fileCanonicalPath;
    private final String fileContent;

    ResourceFile(String resourceName) {
        this.resourceName = resourceName;
        this.fileCanonicalPath = ResourceFile.getResourcePath(resourceName);
        this.fileContent = this.getResourceFileContent(resourceName);
    }

    String getResourceFileContent(String resourceName) {
        String string;
        InputStreamReader inputStream = new InputStreamReader(Objects.requireNonNull(JsonSettingsFile.class.getClassLoader().getResourceAsStream(resourceName)), StandardCharsets.UTF_8);
        BufferedReader br = new BufferedReader(inputStream);
        try {
            string = br.lines().collect(Collectors.joining(System.lineSeparator()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(String.format("Reading of resource file '%1$s' was failed", resourceName), e);
            }
        }
        br.close();
        return string;
    }

    static String getResourcePath(String resourceName) {
        try {
            URL resourceURL = JsonSettingsFile.class.getClassLoader().getResource(resourceName);
            return Objects.requireNonNull(resourceURL).getPath();
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException(String.format("Resource file %1$s was not found or cannot be loaded", resourceName), e);
        }
    }

    public String getResourceName() {
        return this.resourceName;
    }

    String getFileCanonicalPath() {
        return this.fileCanonicalPath;
    }

    String getFileContent() {
        return this.fileContent;
    }
}

