/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.core.utilities;

import aquality.selenium.core.configurations.IRetryConfiguration;
import aquality.selenium.core.utilities.IActionRetrier;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.function.Supplier;

public class ActionRetrier
implements IActionRetrier {
    private IRetryConfiguration retryConfiguration;

    @Inject
    public ActionRetrier(IRetryConfiguration retryConfiguration) {
        this.retryConfiguration = retryConfiguration;
    }

    @Override
    public void doWithRetry(Runnable runnable, Collection<Class<? extends Throwable>> handledExceptions) {
        Supplier<Object> supplier = () -> {
            runnable.run();
            return true;
        };
        this.doWithRetry(supplier, handledExceptions);
    }

    @Override
    public <T> T doWithRetry(Supplier<T> function, Collection<Class<? extends Throwable>> handledExceptions) {
        T result = null;
        for (int retryAttemptsLeft = this.retryConfiguration.getNumber(); retryAttemptsLeft >= 0; --retryAttemptsLeft) {
            try {
                result = function.get();
                break;
            }
            catch (Exception exception) {
                if (this.isExceptionHandled(handledExceptions, exception) && retryAttemptsLeft != 0) {
                    try {
                        Thread.sleep(this.retryConfiguration.getPollingInterval().toMillis());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                throw exception;
            }
        }
        return result;
    }

    protected boolean isExceptionHandled(Collection<Class<? extends Throwable>> handledExceptions, Exception exception) {
        return handledExceptions.contains(exception.getClass());
    }
}

