/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.core.logging;

import org.apache.log4j.Appender;

public final class Logger {
    private static ThreadLocal<org.apache.log4j.Logger> log4J = ThreadLocal.withInitial(() -> org.apache.log4j.Logger.getLogger((String)String.valueOf(Thread.currentThread().getId())));
    private static ThreadLocal<Logger> instance = ThreadLocal.withInitial(Logger::new);

    private Logger() {
    }

    public static Logger getInstance() {
        return instance.get();
    }

    public Logger addAppender(Appender appender) {
        log4J.get().addAppender(appender);
        return Logger.getInstance();
    }

    public Logger removeAppender(Appender appender) {
        log4J.get().removeAppender(appender);
        return Logger.getInstance();
    }

    public void debug(String message) {
        log4J.get().debug((Object)message);
    }

    public void debug(String message, Throwable throwable) {
        log4J.get().debug((Object)message, throwable);
    }

    public void info(String message) {
        log4J.get().info((Object)message);
    }

    public void warn(String message) {
        log4J.get().warn((Object)message);
    }

    public void error(String message) {
        log4J.get().error((Object)message);
    }

    public void fatal(String message, Throwable throwable) {
        log4J.get().fatal((Object)String.format("%s: %s", message, throwable.toString()));
    }

    public void info(String key, Object ... params) {
        log4J.get().info((Object)String.format(key, params));
    }

    public void debug(String key, Object ... params) {
        log4J.get().debug((Object)String.format(key, params));
    }
}

