/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.core.localization;

import aquality.selenium.core.configurations.ILoggerConfiguration;
import aquality.selenium.core.localization.ILocalizationManager;
import aquality.selenium.core.localization.ILocalizedLogger;
import aquality.selenium.core.logging.Logger;
import com.google.inject.Inject;

public class LocalizedLogger
implements ILocalizedLogger {
    private final ILocalizationManager localizationManager;
    private final Logger logger;
    private final ILoggerConfiguration loggerConfiguration;

    @Inject
    public LocalizedLogger(ILocalizationManager localizationManager, Logger logger, ILoggerConfiguration loggerConfiguration) {
        this.localizationManager = localizationManager;
        this.logger = logger;
        this.loggerConfiguration = loggerConfiguration;
    }

    private String localizeMessage(String messageKey, Object ... args) {
        return this.localizationManager.getLocalizedMessage(messageKey, args);
    }

    @Override
    public ILoggerConfiguration getConfiguration() {
        return this.loggerConfiguration;
    }

    @Override
    public void infoElementAction(String elementType, String elementName, String messageKey, Object ... args) {
        String message = String.format("%1$s '%2$s' :: %3$s", elementType, elementName, this.localizeMessage(messageKey, args));
        this.logger.info(message);
    }

    @Override
    public void info(String messageKey, Object ... args) {
        this.logger.info(this.localizeMessage(messageKey, args));
    }

    @Override
    public void debug(String messageKey, Object ... args) {
        this.logger.debug(this.localizeMessage(messageKey, args));
    }

    @Override
    public void debug(String messageKey, Throwable throwable, Object ... args) {
        this.logger.debug(this.localizeMessage(messageKey, args), throwable);
    }

    @Override
    public void warn(String messageKey, Object ... args) {
        this.logger.warn(this.localizeMessage(messageKey, args));
    }

    @Override
    public void error(String messageKey, Object ... args) {
        this.logger.error(this.localizeMessage(messageKey, args));
    }

    @Override
    public void fatal(String messageKey, Throwable throwable, Object ... args) {
        this.logger.fatal(this.localizeMessage(messageKey, args), throwable);
    }
}

