/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.core.localization;

import aquality.selenium.core.configurations.ILoggerConfiguration;
import aquality.selenium.core.localization.ILocalizationManager;
import aquality.selenium.core.logging.Logger;
import aquality.selenium.core.utilities.ISettingsFile;
import aquality.selenium.core.utilities.JsonSettingsFile;
import com.google.inject.Inject;

public class LocalizationManager
implements ILocalizationManager {
    private static final String LANG_RESOURCE_TEMPLATE = "localization/%1$s.json";
    private final ISettingsFile localizationFile;
    private final ISettingsFile coreLocalizationFile;
    private final Logger logger;
    private final String locResourceName;

    @Inject
    public LocalizationManager(ILoggerConfiguration loggerConfiguration, Logger logger) {
        this.logger = logger;
        String language = loggerConfiguration.getLanguage();
        this.locResourceName = String.format(LANG_RESOURCE_TEMPLATE, language.toLowerCase());
        ISettingsFile locFile = LocalizationManager.getLocalizationFileIfExist(this.locResourceName);
        this.coreLocalizationFile = new JsonSettingsFile(String.format(LANG_RESOURCE_TEMPLATE, "core." + language.toLowerCase()));
        this.localizationFile = locFile == null ? this.coreLocalizationFile : locFile;
    }

    private static ISettingsFile getLocalizationFileIfExist(String fileName) {
        return LocalizationManager.class.getClassLoader().getResource(fileName) == null ? null : new JsonSettingsFile(fileName);
    }

    @Override
    public String getLocalizedMessage(String messageKey, Object ... args) {
        ISettingsFile locFile;
        String jsonKeyPath = "/".concat(messageKey);
        ISettingsFile iSettingsFile = locFile = this.localizationFile.isValuePresent(jsonKeyPath) ? this.localizationFile : this.coreLocalizationFile;
        if (locFile.isValuePresent(jsonKeyPath)) {
            return String.format(locFile.getValue(jsonKeyPath).toString(), args);
        }
        this.logger.warn(String.format("Cannot find localized message by key '%1$s' in resource file %2$s", jsonKeyPath, this.locResourceName));
        return messageKey;
    }
}

