/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.core.elements.interfaces;

import aquality.selenium.core.elements.DesiredState;
import aquality.selenium.core.elements.ElementState;
import java.time.Duration;
import java.util.List;
import java.util.function.Predicate;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public interface IElementFinder
extends SearchContext {
    default public DesiredState resolveState(ElementState state) {
        Predicate<WebElement> elementStateCondition;
        if (state == ElementState.DISPLAYED) {
            elementStateCondition = WebElement::isDisplayed;
        } else if (state == ElementState.EXISTS_IN_ANY_STATE) {
            elementStateCondition = webElement -> true;
        } else {
            throw new UnsupportedOperationException(state.toString().concat(" state is not recognized"));
        }
        return new DesiredState(elementStateCondition, state.name());
    }

    default public WebElement findElement(By locator, ElementState state, Duration timeout) {
        return this.findElements(locator, this.resolveState(state).withThrowingNoSuchElementException(), timeout).get(0);
    }

    default public WebElement findElement(By locator, ElementState state) {
        return this.findElement(locator, state, null);
    }

    default public WebElement findElement(By locator, Duration timeout) {
        return this.findElement(locator, ElementState.EXISTS_IN_ANY_STATE, timeout);
    }

    default public WebElement findElement(By locator) {
        return this.findElement(locator, ElementState.EXISTS_IN_ANY_STATE, null);
    }

    default public WebElement findElement(By locator, Predicate<WebElement> elementStateCondition, Duration timeout) {
        DesiredState state = new DesiredState(elementStateCondition, "desired").withThrowingNoSuchElementException();
        return this.findElements(locator, state, timeout).get(0);
    }

    default public WebElement findElement(By locator, Predicate<WebElement> elementStateCondition) {
        return this.findElement(locator, elementStateCondition, null);
    }

    default public List<WebElement> findElements(By locator, ElementState state, Duration timeout) {
        return this.findElements(locator, this.resolveState(state).withCatchingTimeoutException(), timeout);
    }

    default public List<WebElement> findElements(By locator, Duration timeout) {
        return this.findElements(locator, ElementState.EXISTS_IN_ANY_STATE, timeout);
    }

    default public List<WebElement> findElements(By locator, ElementState state) {
        return this.findElements(locator, state, null);
    }

    default public List<WebElement> findElements(By locator) {
        return this.findElements(locator, ElementState.EXISTS_IN_ANY_STATE, null);
    }

    default public List<WebElement> findElements(By locator, Predicate<WebElement> elementStateCondition, Duration timeout) {
        DesiredState state = new DesiredState(elementStateCondition, "desired").withCatchingTimeoutException();
        return this.findElements(locator, state, timeout);
    }

    default public List<WebElement> findElements(By locator, Predicate<WebElement> elementStateCondition) {
        return this.findElements(locator, elementStateCondition, null);
    }

    public List<WebElement> findElements(By var1, DesiredState var2, Duration var3);

    default public List<WebElement> findElements(By locator, DesiredState desiredState) {
        return this.findElements(locator, desiredState, null);
    }
}

