/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.core.elements;

import aquality.selenium.core.elements.DesiredState;
import aquality.selenium.core.elements.ElementFinder;
import aquality.selenium.core.localization.ILocalizedLogger;
import aquality.selenium.core.waitings.IConditionalWait;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class RelativeElementFinder
extends ElementFinder {
    private final IConditionalWait conditionalWait;
    private final Supplier<SearchContext> searchContextSupplier;

    public RelativeElementFinder(ILocalizedLogger localizedLogger, IConditionalWait conditionalWait, Supplier<SearchContext> searchContextSupplier) {
        super(localizedLogger, conditionalWait);
        this.conditionalWait = conditionalWait;
        this.searchContextSupplier = searchContextSupplier;
    }

    @Override
    public List<WebElement> findElements(By locator, DesiredState desiredState, Duration timeout) {
        AtomicBoolean wasAnyElementFound = new AtomicBoolean(false);
        ArrayList<WebElement> resultElements = new ArrayList<WebElement>();
        try {
            this.conditionalWait.waitForTrue(() -> this.tryToFindElements(locator, desiredState, wasAnyElementFound, resultElements, this.searchContextSupplier.get()), timeout);
        }
        catch (TimeoutException e) {
            this.handleTimeoutException(new org.openqa.selenium.TimeoutException(e.getMessage(), (Throwable)e), locator, desiredState, wasAnyElementFound.get());
        }
        catch (org.openqa.selenium.TimeoutException e) {
            this.handleTimeoutException(e, locator, desiredState, wasAnyElementFound.get());
        }
        return resultElements;
    }
}

