/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.core.elements;

import aquality.selenium.core.elements.DesiredState;
import aquality.selenium.core.elements.interfaces.IElementFinder;
import aquality.selenium.core.localization.ILocalizedLogger;
import aquality.selenium.core.waitings.IConditionalWait;
import com.google.inject.Inject;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebElement;

public class ElementFinder
implements IElementFinder {
    private final ILocalizedLogger localizedLogger;
    private final IConditionalWait conditionalWait;

    @Inject
    public ElementFinder(ILocalizedLogger localizedLogger, IConditionalWait conditionalWait) {
        this.localizedLogger = localizedLogger;
        this.conditionalWait = conditionalWait;
    }

    @Override
    public List<WebElement> findElements(By locator, DesiredState desiredState, Duration timeout) {
        AtomicBoolean wasAnyElementFound = new AtomicBoolean(false);
        ArrayList<WebElement> resultElements = new ArrayList<WebElement>();
        try {
            this.conditionalWait.waitFor(driver -> this.tryToFindElements(locator, desiredState, wasAnyElementFound, resultElements, (SearchContext)driver), timeout);
        }
        catch (TimeoutException e) {
            this.handleTimeoutException(e, locator, desiredState, wasAnyElementFound.get());
        }
        return resultElements;
    }

    protected boolean tryToFindElements(By locator, DesiredState desiredState, AtomicBoolean wasAnyElementFound, List<WebElement> resultElements, SearchContext context) {
        List currentFoundElements = context.findElements(locator);
        wasAnyElementFound.set(!currentFoundElements.isEmpty());
        currentFoundElements.stream().filter(desiredState.getElementStateCondition()).forEachOrdered(resultElements::add);
        return !resultElements.isEmpty();
    }

    protected void handleTimeoutException(TimeoutException exception, By locator, DesiredState desiredState, boolean wasAnyElementFound) {
        String message = String.format("No elements with locator '%1$s' were found in %2$s state", locator, desiredState.getStateName());
        if (desiredState.isCatchingInTimeoutException()) {
            if (!wasAnyElementFound) {
                if (desiredState.isThrowingNoSuchElementException()) {
                    throw new NoSuchElementException(message);
                }
                this.localizedLogger.debug("loc.no.elements.found.in.state", locator, desiredState.getStateName());
            } else {
                this.localizedLogger.debug("loc.elements.were.found.but.not.in.state", locator, desiredState.getStateName());
            }
        } else {
            String combinedMessage = String.format("%1$s: %2$s", message, exception.getMessage());
            if (desiredState.isThrowingNoSuchElementException() && !wasAnyElementFound) {
                throw new NoSuchElementException(combinedMessage);
            }
            throw new TimeoutException(combinedMessage);
        }
    }
}

