/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.core.elements;

import aquality.selenium.core.elements.ElementState;
import aquality.selenium.core.elements.ElementsCount;
import aquality.selenium.core.elements.interfaces.IElement;
import aquality.selenium.core.elements.interfaces.IElementFactory;
import aquality.selenium.core.elements.interfaces.IElementFinder;
import aquality.selenium.core.elements.interfaces.IElementSupplier;
import aquality.selenium.core.localization.ILocalizationManager;
import aquality.selenium.core.logging.Logger;
import aquality.selenium.core.waitings.IConditionalWait;
import com.google.inject.Inject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.ByChained;

public class ElementFactory
implements IElementFactory {
    private static final int XPATH_SUBSTRING_BEGIN_INDEX = 10;
    private static final int TAGNAME_SUBSTRING_BEGIN_INDEX = 12;
    private static final String TAGNAME_XPATH_PREFIX = "//";
    private static final Duration ZERO_TIMEOUT = Duration.ZERO;
    private final IConditionalWait conditionalWait;
    private final IElementFinder elementFinder;
    private final ILocalizationManager localizationManager;

    @Inject
    public ElementFactory(IConditionalWait conditionalWait, IElementFinder elementFinder, ILocalizationManager localizationManager) {
        this.conditionalWait = conditionalWait;
        this.elementFinder = elementFinder;
        this.localizationManager = localizationManager;
    }

    @Override
    public <T extends IElement> T getCustomElement(IElementSupplier<T> elementSupplier, By locator, String name, ElementState state) {
        return elementSupplier.get(locator, name, state);
    }

    @Override
    public <T extends IElement> T getCustomElement(Class<T> clazz, By locator, String name, ElementState state) {
        IElementSupplier<T> elementSupplier = this.getDefaultElementSupplier(clazz);
        return this.getCustomElement(elementSupplier, locator, name, state);
    }

    @Override
    public <T extends IElement> T findChildElement(IElement parentElement, By childLoc, String name, Class<T> clazz, ElementState state) {
        IElementSupplier<T> elementSupplier = this.getDefaultElementSupplier(clazz);
        return this.findChildElement(parentElement, childLoc, name, elementSupplier, state);
    }

    @Override
    public <T extends IElement> T findChildElement(IElement parentElement, By childLoc, String name, IElementSupplier<T> supplier, ElementState state) {
        String childName = name == null ? "Child element of ".concat(parentElement.getName()) : name;
        By fullLocator = this.generateAbsoluteChildLocator(parentElement.getLocator(), childLoc);
        return supplier.get(fullLocator, childName, state);
    }

    @Override
    public <T extends IElement> List<T> findChildElements(IElement parentElement, By childLoc, String name, Class<T> clazz, ElementsCount count, ElementState state) {
        IElementSupplier<T> elementSupplier = this.getDefaultElementSupplier(clazz);
        return this.findChildElements(parentElement, childLoc, name, elementSupplier, count, state);
    }

    @Override
    public <T extends IElement> List<T> findChildElements(IElement parentElement, By childLoc, String name, IElementSupplier<T> supplier, ElementsCount count, ElementState state) {
        String childName = name == null ? "Child element of ".concat(parentElement.getName()) : name;
        By fullLocator = this.generateAbsoluteChildLocator(parentElement.getLocator(), childLoc);
        return this.findElements(fullLocator, childName, supplier, count, state);
    }

    @Override
    public <T extends IElement> List<T> findElements(By locator, String name, IElementSupplier<T> supplier, ElementsCount count, ElementState state) {
        try {
            this.waitForElementsCount(locator, count, state);
        }
        catch (java.util.concurrent.TimeoutException e) {
            throw new TimeoutException(e.getMessage());
        }
        List<WebElement> webElements = this.elementFinder.findElements(locator, state, ZERO_TIMEOUT);
        String namePrefix = name == null ? "element" : name;
        ArrayList<T> list = new ArrayList<T>();
        for (int index = 1; index <= webElements.size(); ++index) {
            WebElement webElement = webElements.get(index - 1);
            String currentName = String.format("%1$s %2$s", namePrefix, index);
            T element = supplier.get(this.generateXpathLocator(locator, webElement, index), currentName, state);
            list.add(element);
        }
        return list;
    }

    protected void waitForElementsCount(By locator, ElementsCount count, ElementState state) throws java.util.concurrent.TimeoutException {
        switch (count) {
            case ZERO: {
                this.conditionalWait.waitForTrue(() -> this.elementFinder.findElements(locator, state, ZERO_TIMEOUT).isEmpty(), this.localizationManager.getLocalizedMessage("loc.elements.found.but.should.not", locator.toString(), state.toString()));
                break;
            }
            case MORE_THEN_ZERO: {
                this.conditionalWait.waitForTrue(() -> !this.elementFinder.findElements(locator, state, ZERO_TIMEOUT).isEmpty(), this.localizationManager.getLocalizedMessage("loc.no.elements.found.by.locator", locator.toString(), state.toString()));
                break;
            }
            case ANY: {
                this.conditionalWait.waitFor(() -> this.elementFinder.findElements(locator, state, ZERO_TIMEOUT) != null);
                break;
            }
            default: {
                throw new IllegalArgumentException("No such expected value: ".concat(count.toString()));
            }
        }
    }

    @Override
    public <T extends IElement> List<T> findElements(By locator, String name, Class<T> clazz, ElementsCount count, ElementState state) {
        IElementSupplier<T> elementSupplier = this.getDefaultElementSupplier(clazz);
        return this.findElements(locator, name, elementSupplier, count, state);
    }

    protected By generateXpathLocator(By multipleElementsLocator, WebElement webElement, int elementIndex) {
        if (this.isLocatorSupportedForXPathExtraction(multipleElementsLocator)) {
            return By.xpath((String)String.format("(%1$s)[%2$s]", this.extractXPathFromLocator(multipleElementsLocator), elementIndex));
        }
        throw new InvalidArgumentException(String.format("Cannot define unique baseLocator for element %1$s. Multiple elements' baseLocator type %2$s is not supported yet", webElement.toString(), multipleElementsLocator.getClass()));
    }

    protected String extractXPathFromLocator(By locator) {
        Class<By.ByXPath> supportedLocatorType = By.ByXPath.class;
        if (locator.getClass().equals(supportedLocatorType)) {
            return locator.toString().substring(10);
        }
        if (locator.getClass().equals(By.ByTagName.class)) {
            return TAGNAME_XPATH_PREFIX + locator.toString().substring(12);
        }
        throw new InvalidArgumentException(String.format("Cannot define xpath from locator %1$s. Locator type %2$s is not %3$s, and is not supported yet", locator.toString(), locator.getClass(), supportedLocatorType));
    }

    protected By generateAbsoluteChildLocator(By parentLoc, By childLoc) {
        if (this.isLocatorSupportedForXPathExtraction(parentLoc) && this.isLocatorSupportedForXPathExtraction(childLoc)) {
            String childLocString = this.extractXPathFromLocator(childLoc);
            String parentLocString = this.extractXPathFromLocator(parentLoc);
            return By.xpath((String)parentLocString.concat(childLocString.startsWith(".") ? childLocString.substring(1) : childLocString));
        }
        return new ByChained(new By[]{parentLoc, childLoc});
    }

    protected boolean isLocatorSupportedForXPathExtraction(By locator) {
        return locator.getClass().equals(By.ByXPath.class) || locator.getClass().equals(By.ByTagName.class);
    }

    protected Map<Class<? extends IElement>, Class<? extends IElement>> getElementTypesMap() {
        return new HashMap<Class<? extends IElement>, Class<? extends IElement>>();
    }

    protected <T extends IElement> Class<T> resolveElementClass(Class<T> clazz) {
        if (clazz.isInterface() && !this.getElementTypesMap().containsKey(clazz)) {
            throw new IllegalArgumentException(String.format("Interface %1$s is not found in getElementTypesMap()", clazz));
        }
        return clazz.isInterface() ? this.getElementTypesMap().get(clazz) : clazz;
    }

    protected <T extends IElement> IElementSupplier<T> getDefaultElementSupplier(Class<T> clazz) {
        return (locator, name, state) -> {
            try {
                Constructor ctor = this.resolveElementClass(clazz).getDeclaredConstructor(By.class, String.class, ElementState.class);
                ctor.setAccessible(true);
                IElement instance = (IElement)ctor.newInstance(new Object[]{locator, name, state});
                ctor.setAccessible(false);
                return instance;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                Logger.getInstance().debug(e.getMessage());
                throw new IllegalArgumentException("Something went wrong during element casting");
            }
        };
    }
}

