/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.core.elements;

import aquality.selenium.core.elements.ElementState;
import aquality.selenium.core.elements.interfaces.IElementCacheHandler;
import aquality.selenium.core.elements.interfaces.IElementFinder;
import java.time.Duration;
import org.openqa.selenium.By;
import org.openqa.selenium.remote.RemoteWebElement;

public class ElementCacheHandler
implements IElementCacheHandler {
    private final By locator;
    private final ElementState state;
    private final IElementFinder finder;
    private RemoteWebElement remoteElement;

    public ElementCacheHandler(By locator, ElementState state, IElementFinder finder) {
        this.locator = locator;
        this.state = state;
        this.finder = finder;
    }

    @Override
    public boolean isRefreshNeeded(ElementState customState) {
        if (!this.wasCached()) {
            return true;
        }
        try {
            boolean isDisplayed = this.remoteElement.isDisplayed();
            ElementState requiredState = customState == null ? this.state : customState;
            return requiredState == ElementState.DISPLAYED && !isDisplayed;
        }
        catch (Exception e) {
            return true;
        }
    }

    @Override
    public boolean wasCached() {
        return this.remoteElement != null;
    }

    @Override
    public RemoteWebElement getElement(Duration timeout, ElementState customState) {
        ElementState requiredState;
        ElementState elementState = requiredState = customState == null ? this.state : customState;
        if (this.isRefreshNeeded(requiredState)) {
            this.remoteElement = (RemoteWebElement)this.finder.findElement(this.locator, requiredState, timeout);
        }
        return this.remoteElement;
    }
}

