/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.core.elements;

import aquality.selenium.core.applications.IApplication;
import aquality.selenium.core.configurations.IElementCacheConfiguration;
import aquality.selenium.core.configurations.ILoggerConfiguration;
import aquality.selenium.core.elements.CachedElementStateProvider;
import aquality.selenium.core.elements.DefaultElementStateProvider;
import aquality.selenium.core.elements.ElementCacheHandler;
import aquality.selenium.core.elements.ElementState;
import aquality.selenium.core.elements.ElementsCount;
import aquality.selenium.core.elements.interfaces.IElement;
import aquality.selenium.core.elements.interfaces.IElementCacheHandler;
import aquality.selenium.core.elements.interfaces.IElementFactory;
import aquality.selenium.core.elements.interfaces.IElementFinder;
import aquality.selenium.core.elements.interfaces.IElementStateProvider;
import aquality.selenium.core.elements.interfaces.IElementSupplier;
import aquality.selenium.core.elements.interfaces.ILogElementState;
import aquality.selenium.core.localization.ILocalizationManager;
import aquality.selenium.core.localization.ILocalizedLogger;
import aquality.selenium.core.logging.Logger;
import aquality.selenium.core.utilities.IElementActionRetrier;
import aquality.selenium.core.waitings.IConditionalWait;
import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.RemoteWebElement;

public abstract class Element
implements IElement {
    private final String name;
    private final ElementState elementState;
    private final By locator;
    private IElementCacheHandler elementCacheHandler;

    protected Element(By loc, String name, ElementState state) {
        this.locator = loc;
        this.name = name;
        this.elementState = state;
    }

    protected abstract IApplication getApplication();

    protected abstract IElementFactory getElementFactory();

    protected abstract IElementFinder getElementFinder();

    protected abstract IElementCacheConfiguration getElementCacheConfiguration();

    protected abstract IElementActionRetrier getElementActionRetrier();

    protected abstract ILocalizedLogger getLocalizedLogger();

    protected abstract ILocalizationManager getLocalizationManager();

    protected abstract IConditionalWait getConditionalWait();

    protected abstract String getElementType();

    protected IElementCacheHandler getCache() {
        if (this.elementCacheHandler == null) {
            this.elementCacheHandler = new ElementCacheHandler(this.locator, this.elementState, this.getElementFinder());
        }
        return this.elementCacheHandler;
    }

    protected ILoggerConfiguration getLoggerConfiguration() {
        return this.getLocalizedLogger().getConfiguration();
    }

    protected Logger getLogger() {
        return Logger.getInstance();
    }

    protected ILogElementState logElementState() {
        return (messageKey, stateKey) -> this.getLocalizedLogger().infoElementAction(this.getElementType(), this.getName(), messageKey, this.getLocalizationManager().getLocalizedMessage(stateKey, new Object[0]));
    }

    @Override
    public By getLocator() {
        return this.locator;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IElementStateProvider state() {
        return this.getElementCacheConfiguration().isEnabled() ? new CachedElementStateProvider(this.locator, this.getConditionalWait(), this.getCache(), this.logElementState()) : new DefaultElementStateProvider(this.locator, this.getConditionalWait(), this.getElementFinder(), this.logElementState());
    }

    @Override
    public RemoteWebElement getElement(Duration timeout) {
        try {
            return this.getElementCacheConfiguration().isEnabled() ? this.getCache().getElement(timeout) : (RemoteWebElement)this.getElementFinder().findElement(this.locator, this.elementState, timeout);
        }
        catch (NoSuchElementException e) {
            if (this.getLoggerConfiguration().logPageSource()) {
                this.logPageSource((WebDriverException)e);
            }
            throw e;
        }
    }

    protected void logPageSource(WebDriverException exception) {
        try {
            this.getLogger().debug("Page source:".concat(System.lineSeparator()).concat(this.getApplication().getDriver().getPageSource()), exception);
        }
        catch (WebDriverException e) {
            this.getLogger().error(exception.getMessage());
            this.getLocalizedLogger().fatal("loc.get.page.source.failed", e, new Object[0]);
        }
    }

    @Override
    public String getText() {
        this.logElementAction("loc.get.text", new Object[0]);
        String value = this.doWithRetry(() -> this.getElement().getText());
        this.logElementAction("loc.text.value", value);
        return value;
    }

    @Override
    public String getAttribute(String attr) {
        this.logElementAction("loc.el.getattr", attr);
        String value = this.doWithRetry(() -> this.getElement().getAttribute(attr));
        this.logElementAction("loc.el.attr.value", attr, value);
        return value;
    }

    @Override
    public void sendKeys(String keys) {
        this.logElementAction("loc.text.sending.keys", keys);
        this.doWithRetry(() -> this.getElement().sendKeys(new CharSequence[]{keys}));
    }

    @Override
    public void click() {
        this.logElementAction("loc.clicking", new Object[0]);
        this.doWithRetry(() -> this.getElement().click());
    }

    @Override
    public <T extends IElement> T findChildElement(By childLoc, String name, Class<T> clazz, ElementState state) {
        return this.getElementFactory().findChildElement((IElement)this, childLoc, name, clazz, state);
    }

    @Override
    public <T extends IElement> T findChildElement(By childLoc, String name, IElementSupplier<T> supplier, ElementState state) {
        return this.getElementFactory().findChildElement((IElement)this, childLoc, name, supplier, state);
    }

    @Override
    public <T extends IElement> List<T> findChildElements(By childLoc, String name, Class<T> clazz, ElementState state, ElementsCount count) {
        return this.getElementFactory().findChildElements((IElement)this, childLoc, name, clazz, count, state);
    }

    @Override
    public <T extends IElement> List<T> findChildElements(By childLoc, String name, IElementSupplier<T> supplier, ElementState state, ElementsCount count) {
        return this.getElementFactory().findChildElements((IElement)this, childLoc, name, supplier, count, state);
    }

    protected <T> T doWithRetry(Supplier<T> action) {
        return this.getElementActionRetrier().doWithRetry(action);
    }

    protected void doWithRetry(Runnable action) {
        this.getElementActionRetrier().doWithRetry(action);
    }

    protected void logElementAction(String messageKey, Object ... args) {
        this.getLocalizedLogger().infoElementAction(this.getElementType(), this.name, messageKey, args);
    }

    protected ElementState getElementState() {
        return this.elementState;
    }
}

