/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.core.elements;

import aquality.selenium.core.elements.DesiredState;
import aquality.selenium.core.elements.ElementState;
import aquality.selenium.core.elements.ElementStateProvider;
import aquality.selenium.core.elements.interfaces.IElementFinder;
import aquality.selenium.core.elements.interfaces.ILogElementState;
import aquality.selenium.core.waitings.IConditionalWait;
import java.time.Duration;
import java.util.function.BooleanSupplier;
import org.openqa.selenium.By;

public class DefaultElementStateProvider
extends ElementStateProvider {
    private final By locator;
    private final IConditionalWait conditionalWait;
    private final IElementFinder elementFinder;

    public DefaultElementStateProvider(By locator, IConditionalWait conditionalWait, IElementFinder elementFinder, ILogElementState logger) {
        super(logger);
        this.locator = locator;
        this.conditionalWait = conditionalWait;
        this.elementFinder = elementFinder;
    }

    @Override
    public boolean isClickable() {
        return this.waitForIsClickable(Duration.ZERO, true);
    }

    @Override
    public void waitForClickable(Duration timeout) {
        try {
            this.waitForIsClickable(timeout, false);
        }
        catch (Exception e) {
            this.logElementState("loc.wait.for.state.failed", this.elementClickable().getStateName());
            throw e;
        }
    }

    private boolean waitForIsClickable(Duration timeout, boolean catchTimeoutException) {
        DesiredState desiredState = this.elementClickable();
        desiredState = catchTimeoutException ? desiredState.withCatchingTimeoutException() : desiredState;
        return this.isElementInDesiredCondition(desiredState, timeout);
    }

    private boolean isElementInDesiredCondition(DesiredState elementStateCondition, Duration timeout) {
        return this.doAndLogWaitForState(() -> !this.elementFinder.findElements(this.locator, elementStateCondition, timeout).isEmpty(), elementStateCondition.getStateName(), timeout);
    }

    @Override
    public boolean isDisplayed() {
        return this.waitForDisplayed(Duration.ZERO);
    }

    @Override
    public boolean waitForDisplayed(Duration timeout) {
        return this.doAndLogWaitForState(() -> this.isAnyElementFound(timeout, ElementState.DISPLAYED), "displayed", timeout);
    }

    private boolean isAnyElementFound(Duration timeout, ElementState state) {
        return !this.elementFinder.findElements(this.locator, state, timeout).isEmpty();
    }

    @Override
    public boolean waitForNotDisplayed(Duration timeout) {
        return this.doAndLogWaitForState(() -> this.conditionalWait.waitFor(() -> !this.isDisplayed(), timeout), "not.displayed", timeout);
    }

    @Override
    public boolean isExist() {
        return this.waitForExist(Duration.ZERO);
    }

    @Override
    public boolean waitForExist(Duration timeout) {
        return this.doAndLogWaitForState(() -> this.isAnyElementFound(timeout, ElementState.EXISTS_IN_ANY_STATE), "exist", timeout);
    }

    @Override
    public boolean waitForNotExist(Duration timeout) {
        return this.doAndLogWaitForState(() -> this.conditionalWait.waitFor(() -> !this.isExist(), timeout), "not.exist", timeout);
    }

    @Override
    public boolean isEnabled() {
        return this.waitForEnabled(Duration.ZERO);
    }

    @Override
    public boolean waitForEnabled(Duration timeout) {
        return this.isElementInDesiredCondition(this.elementEnabled(), timeout);
    }

    @Override
    public boolean waitForNotEnabled(Duration timeout) {
        return this.isElementInDesiredCondition(this.elementNotEnabled(), timeout);
    }

    private boolean doAndLogWaitForState(BooleanSupplier waitingAction, String conditionKeyPart, Duration timeout) {
        if (Duration.ZERO.equals(timeout)) {
            return waitingAction.getAsBoolean();
        }
        this.logElementState("loc.wait.for.state", conditionKeyPart);
        boolean result = waitingAction.getAsBoolean();
        if (!result) {
            this.logElementState("loc.wait.for.state.failed", conditionKeyPart);
        }
        return result;
    }
}

