/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.core.elements;

import aquality.selenium.core.elements.ElementState;
import aquality.selenium.core.elements.ElementStateProvider;
import aquality.selenium.core.elements.interfaces.IElementCacheHandler;
import aquality.selenium.core.elements.interfaces.ILogElementState;
import aquality.selenium.core.waitings.IConditionalWait;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;

public class CachedElementStateProvider
extends ElementStateProvider {
    private final By locator;
    private final IConditionalWait conditionalWait;
    private final IElementCacheHandler elementCacheHandler;

    public CachedElementStateProvider(By locator, IConditionalWait conditionalWait, IElementCacheHandler elementCacheHandler, ILogElementState logger) {
        super(logger);
        this.locator = locator;
        this.conditionalWait = conditionalWait;
        this.elementCacheHandler = elementCacheHandler;
    }

    protected List<Class<? extends Exception>> getHandledExceptions() {
        return Arrays.asList(StaleElementReferenceException.class, NoSuchElementException.class);
    }

    protected boolean tryInvokeFunction(Predicate<WebElement> predicate) {
        return this.tryInvokeFunction(predicate, this.getHandledExceptions());
    }

    protected boolean tryInvokeFunction(Predicate<WebElement> predicate, List<Class<? extends Exception>> handledExceptions) {
        try {
            return predicate.test((WebElement)this.elementCacheHandler.getElement(Duration.ZERO, ElementState.EXISTS_IN_ANY_STATE));
        }
        catch (Exception exception) {
            if (handledExceptions.contains(exception.getClass())) {
                return false;
            }
            throw exception;
        }
    }

    protected boolean waitForCondition(BooleanSupplier condition, String conditionKeyPart, Duration timeout) {
        this.logElementState("loc.wait.for.state", conditionKeyPart);
        boolean result = this.conditionalWait.waitFor(condition, timeout);
        if (!result) {
            this.logElementState("loc.wait.for.state.failed", conditionKeyPart);
        }
        return result;
    }

    @Override
    public boolean isClickable() {
        return this.tryInvokeFunction(this.elementClickable().getElementStateCondition());
    }

    @Override
    public void waitForClickable(Duration timeout) {
        String errorMessage = String.format("Element %1$s has not become clickable after timeout.", this.locator);
        String conditionKeyPart = this.elementClickable().getStateName();
        try {
            this.logElementState("loc.wait.for.state", conditionKeyPart);
            this.conditionalWait.waitForTrue(this::isClickable, timeout, null, errorMessage);
        }
        catch (TimeoutException e) {
            this.logElementState("loc.wait.for.state.failed", conditionKeyPart);
            throw new org.openqa.selenium.TimeoutException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isDisplayed() {
        return !this.elementCacheHandler.isStale() && this.tryInvokeFunction(WebElement::isDisplayed);
    }

    @Override
    public boolean waitForDisplayed(Duration timeout) {
        return this.waitForCondition(() -> this.tryInvokeFunction(WebElement::isDisplayed), "displayed", timeout);
    }

    @Override
    public boolean waitForNotDisplayed(Duration timeout) {
        return this.waitForCondition(() -> !this.isDisplayed(), "not.displayed", timeout);
    }

    @Override
    public boolean isExist() {
        return !this.elementCacheHandler.isStale() && this.tryInvokeFunction(element -> true);
    }

    @Override
    public boolean waitForExist(Duration timeout) {
        return this.waitForCondition(() -> this.tryInvokeFunction(element -> true), "exist", timeout);
    }

    @Override
    public boolean waitForNotExist(Duration timeout) {
        return this.waitForCondition(() -> !this.isExist(), "not.exist", timeout);
    }

    @Override
    public boolean isEnabled() {
        return this.tryInvokeFunction(this.elementEnabled().getElementStateCondition(), Collections.singletonList(StaleElementReferenceException.class));
    }

    @Override
    public boolean waitForEnabled(Duration timeout) {
        return this.waitForCondition(this::isEnabled, this.elementEnabled().getStateName(), timeout);
    }

    @Override
    public boolean waitForNotEnabled(Duration timeout) {
        return this.waitForCondition(() -> !this.isEnabled(), this.elementNotEnabled().getStateName(), timeout);
    }
}

