/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.core.configurations;

import aquality.selenium.core.configurations.ITimeoutConfiguration;
import aquality.selenium.core.utilities.ISettingsFile;
import com.google.inject.Inject;
import java.time.Duration;

public class TimeoutConfiguration
implements ITimeoutConfiguration {
    private final ISettingsFile settingsFile;
    private final Duration condition;
    private final Duration pollInterval;
    private final Duration implicit;
    private final Duration command;

    @Inject
    public TimeoutConfiguration(ISettingsFile settingsFile) {
        this.settingsFile = settingsFile;
        this.condition = this.getDurationFromSeconds(TIMEOUT.CONDITION);
        this.pollInterval = Duration.ofMillis(this.getTimeout(TIMEOUT.POLL_INTERVAL));
        this.implicit = this.getDurationFromSeconds(TIMEOUT.IMPLICIT);
        this.command = this.getDurationFromSeconds(TIMEOUT.COMMAND);
    }

    private long getTimeout(TIMEOUT timeout) {
        return Long.valueOf(this.settingsFile.getValue(timeout.getKey()).toString());
    }

    private Duration getDurationFromSeconds(TIMEOUT timeout) {
        return Duration.ofSeconds(this.getTimeout(timeout));
    }

    @Override
    public Duration getImplicit() {
        return this.implicit;
    }

    @Override
    public Duration getCondition() {
        return this.condition;
    }

    @Override
    public Duration getPollingInterval() {
        return this.pollInterval;
    }

    @Override
    public Duration getCommand() {
        return this.command;
    }

    private static enum TIMEOUT {
        IMPLICIT("/timeouts/timeoutImplicit"),
        CONDITION("/timeouts/timeoutCondition"),
        POLL_INTERVAL("/timeouts/timeoutPollingInterval"),
        COMMAND("/timeouts/timeoutCommand");

        private String key;

        private TIMEOUT(String key) {
            this.key = key;
        }

        private String getKey() {
            return this.key;
        }
    }
}

