/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.core.configurations;

import aquality.selenium.core.configurations.ILoggerConfiguration;
import aquality.selenium.core.utilities.ISettingsFile;
import com.google.inject.Inject;

public class LoggerConfiguration
implements ILoggerConfiguration {
    private static final String DEFAULT_LANGUAGE = "en";
    private final String language;
    private final boolean doLogPageSource;

    @Inject
    public LoggerConfiguration(ISettingsFile settingsFile) {
        this.language = settingsFile.getValueOrDefault("/logger/language", DEFAULT_LANGUAGE).toString();
        this.doLogPageSource = Boolean.parseBoolean(settingsFile.getValueOrDefault("/logger/logPageSource", true).toString());
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public boolean logPageSource() {
        return this.doLogPageSource;
    }
}

