/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.core.applications;

import aquality.selenium.core.applications.AqualityModule;
import aquality.selenium.core.applications.IApplication;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class AqualityServices<T extends IApplication> {
    private T app;
    private final Injector injector;

    protected <V extends AqualityModule<T>> AqualityServices(Provider<T> applicationProvider, Supplier<V> servicesModuleSupplier) {
        AqualityModule<T> module = servicesModuleSupplier == null ? new AqualityModule<T>(applicationProvider) : (AqualityModule)servicesModuleSupplier.get();
        this.injector = Guice.createInjector((Module[])new Module[]{module});
    }

    protected boolean isAppStarted() {
        return this.app != null && this.app.isStarted();
    }

    protected void setApp(T application) {
        this.app = application;
    }

    protected T getApp(Function<Injector, T> startApplicationFunction) {
        if (!this.isAppStarted()) {
            this.setApp((IApplication)startApplicationFunction.apply(this.injector));
        }
        return this.app;
    }

    protected Injector getInjector() {
        return this.injector;
    }
}

