/*
 * Decompiled with CFR 0.152.
 */
package aquality.selenium.core.applications;

import aquality.selenium.core.applications.IApplication;
import aquality.selenium.core.configurations.IConfigurationsModule;
import aquality.selenium.core.configurations.IElementCacheConfiguration;
import aquality.selenium.core.configurations.ILoggerConfiguration;
import aquality.selenium.core.configurations.IRetryConfiguration;
import aquality.selenium.core.configurations.ITimeoutConfiguration;
import aquality.selenium.core.elements.IElementsModule;
import aquality.selenium.core.elements.interfaces.IElementFactory;
import aquality.selenium.core.elements.interfaces.IElementFinder;
import aquality.selenium.core.localization.ILocalizationManager;
import aquality.selenium.core.localization.ILocalizationModule;
import aquality.selenium.core.localization.ILocalizedLogger;
import aquality.selenium.core.logging.Logger;
import aquality.selenium.core.utilities.IActionRetrier;
import aquality.selenium.core.utilities.IElementActionRetrier;
import aquality.selenium.core.utilities.ISettingsFile;
import aquality.selenium.core.utilities.IUtilitiesModule;
import aquality.selenium.core.waitings.IConditionalWait;
import aquality.selenium.core.waitings.IWaitingsModule;
import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.Singleton;

public class AqualityModule<T extends IApplication>
extends AbstractModule
implements IConfigurationsModule,
IElementsModule,
ILocalizationModule,
IUtilitiesModule,
IWaitingsModule {
    private final Provider<T> applicationProvider;

    public AqualityModule(Provider<T> applicationProvider) {
        this.applicationProvider = applicationProvider;
    }

    protected void configure() {
        this.bind(IApplication.class).toProvider(this.applicationProvider);
        this.bind(ISettingsFile.class).toInstance((Object)this.getInstanceOfSettingsFile());
        this.bind(Logger.class).toInstance((Object)Logger.getInstance());
        this.bind(ILoggerConfiguration.class).to(this.getLoggerConfigurationImplementation()).in(Singleton.class);
        this.bind(ITimeoutConfiguration.class).to(this.getTimeoutConfigurationImplementation()).in(Singleton.class);
        this.bind(IRetryConfiguration.class).to(this.getRetryConfigurationImplementation()).in(Singleton.class);
        this.bind(IElementCacheConfiguration.class).to(this.getElementCacheConfigurationImplementation()).in(Singleton.class);
        this.bind(IElementActionRetrier.class).to(this.getElementActionRetrierImplementation()).in(Singleton.class);
        this.bind(IActionRetrier.class).to(this.getActionRetrierImplementation()).in(Singleton.class);
        this.bind(ILocalizationManager.class).to(this.getLocalizationManagerImplementation()).in(Singleton.class);
        this.bind(ILocalizedLogger.class).to(this.getLocalizedLoggerImplementation()).in(Singleton.class);
        this.bind(IConditionalWait.class).to(this.getConditionalWaitImplementation());
        this.bind(IElementFinder.class).to(this.getElementFinderImplementation());
        this.bind(IElementFactory.class).to(this.getElementFactoryImplementation());
    }
}

