/*
 * Decompiled with CFR 0.152.
 */
package com.vader.sentiment.util;

import com.vader.sentiment.util.Valence;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class Utils {
    private static final ClassLoader CLASS_LOADER = Utils.class.getClassLoader();
    private static final String[] PUNCTUATION_LIST_ARRAY = new String[]{".", "!", "?", ",", ";", ":", "-", "'", "\"", "!!", "!!!", "??", "???", "?!?", "!?!", "?!?!", "!?!?"};
    private static final String[] NEGATIVE_WORDS_ARRAY = new String[]{"aint", "arent", "cannot", "cant", "couldnt", "darent", "didnt", "doesnt", "ain't", "aren't", "can't", "couldn't", "daren't", "didn't", "doesn't", "dont", "hadnt", "hasnt", "havent", "isnt", "mightnt", "mustnt", "neither", "don't", "hadn't", "hasn't", "haven't", "isn't", "mightn't", "mustn't", "neednt", "needn't", "never", "none", "nope", "nor", "not", "nothing", "nowhere", "oughtnt", "shant", "shouldnt", "uhuh", "wasnt", "werent", "oughtn't", "shan't", "shouldn't", "uh-uh", "wasn't", "weren't", "without", "wont", "wouldnt", "won't", "wouldn't", "rarely", "seldom", "despite"};
    public static final ArrayList<String> PUNCTUATION_LIST = new ArrayList<String>(Arrays.asList(PUNCTUATION_LIST_ARRAY));
    public static final Set<String> NEGATIVE_WORDS = new HashSet<String>(Arrays.asList(NEGATIVE_WORDS_ARRAY));
    private static Map<String, Float> BoosterDictionary = new HashMap<String, Float>();
    private static Map<String, Float> SentimentLadenIdioms;
    private static Map<String, Float> WordValenceDictionary;

    private Utils() {
    }

    public static boolean isUpper(String token) {
        if (token.toLowerCase().startsWith("http://")) {
            return false;
        }
        if (!token.matches(".*[a-zA-Z]+.*")) {
            return false;
        }
        for (int i = 0; i < token.length(); ++i) {
            if (!Character.isLowerCase(token.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static Map<String, Float> readLexiconFile() {
        InputStream lexFile = CLASS_LOADER.getResourceAsStream("vader_sentiment_lexicon.txt");
        HashMap<String, Float> lexDictionary = new HashMap<String, Float>();
        if (lexFile != null) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(lexFile));){
                String line;
                while ((line = br.readLine()) != null) {
                    String[] lexFileData = line.split("\\t");
                    String currentText = lexFileData[0];
                    Float currentTextValence = Float.valueOf(Float.parseFloat(lexFileData[1]));
                    lexDictionary.put(currentText, currentTextValence);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return lexDictionary;
    }

    public static Map<String, Float> getSentimentLadenIdioms() {
        return SentimentLadenIdioms;
    }

    public static Map<String, Float> getBoosterDictionary() {
        return BoosterDictionary;
    }

    public static Map<String, Float> getWordValenceDictionary() {
        return WordValenceDictionary;
    }

    static {
        BoosterDictionary.put("decidedly", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("uber", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("barely", Float.valueOf(Valence.DEFAULT_DAMPING.getValue()));
        BoosterDictionary.put("particularly", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("enormously", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("less", Float.valueOf(Valence.DEFAULT_DAMPING.getValue()));
        BoosterDictionary.put("absolutely", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("kinda", Float.valueOf(Valence.DEFAULT_DAMPING.getValue()));
        BoosterDictionary.put("flipping", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("awfully", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("purely", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("majorly", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("substantially", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("partly", Float.valueOf(Valence.DEFAULT_DAMPING.getValue()));
        BoosterDictionary.put("remarkably", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("really", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("sort of", Float.valueOf(Valence.DEFAULT_DAMPING.getValue()));
        BoosterDictionary.put("little", Float.valueOf(Valence.DEFAULT_DAMPING.getValue()));
        BoosterDictionary.put("fricking", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("sorta", Float.valueOf(Valence.DEFAULT_DAMPING.getValue()));
        BoosterDictionary.put("amazingly", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("kind of", Float.valueOf(Valence.DEFAULT_DAMPING.getValue()));
        BoosterDictionary.put("just enough", Float.valueOf(Valence.DEFAULT_DAMPING.getValue()));
        BoosterDictionary.put("fucking", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("occasionally", Float.valueOf(Valence.DEFAULT_DAMPING.getValue()));
        BoosterDictionary.put("somewhat", Float.valueOf(Valence.DEFAULT_DAMPING.getValue()));
        BoosterDictionary.put("kindof", Float.valueOf(Valence.DEFAULT_DAMPING.getValue()));
        BoosterDictionary.put("friggin", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("incredibly", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("totally", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("marginally", Float.valueOf(Valence.DEFAULT_DAMPING.getValue()));
        BoosterDictionary.put("more", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("considerably", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("fabulously", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("hardly", Float.valueOf(Valence.DEFAULT_DAMPING.getValue()));
        BoosterDictionary.put("very", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("sortof", Float.valueOf(Valence.DEFAULT_DAMPING.getValue()));
        BoosterDictionary.put("kind-of", Float.valueOf(Valence.DEFAULT_DAMPING.getValue()));
        BoosterDictionary.put("scarcely", Float.valueOf(Valence.DEFAULT_DAMPING.getValue()));
        BoosterDictionary.put("thoroughly", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("quite", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("most", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("completely", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("frigging", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("intensely", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("utterly", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("highly", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("extremely", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("unbelievably", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("almost", Float.valueOf(Valence.DEFAULT_DAMPING.getValue()));
        BoosterDictionary.put("especially", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("fully", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("frickin", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("tremendously", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("exceptionally", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("flippin", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("hella", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("so", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("greatly", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("hugely", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("deeply", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("unusually", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("entirely", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        BoosterDictionary.put("slightly", Float.valueOf(Valence.DEFAULT_DAMPING.getValue()));
        BoosterDictionary.put("effing", Float.valueOf(Valence.DEFAULT_BOOSTING.getValue()));
        SentimentLadenIdioms = new HashMap<String, Float>();
        SentimentLadenIdioms.put("cut the mustard", Float.valueOf(2.0f));
        SentimentLadenIdioms.put("bad ass", Float.valueOf(1.5f));
        SentimentLadenIdioms.put("kiss of death", Float.valueOf(-1.5f));
        SentimentLadenIdioms.put("yeah right", Float.valueOf(-2.0f));
        SentimentLadenIdioms.put("the bomb", Float.valueOf(3.0f));
        SentimentLadenIdioms.put("hand to mouth", Float.valueOf(-2.0f));
        SentimentLadenIdioms.put("the shit", Float.valueOf(3.0f));
        WordValenceDictionary = Utils.readLexiconFile();
    }
}

