/*
 * Decompiled with CFR 0.152.
 */
package com.vader.sentiment.processor;

import com.vader.sentiment.processor.InputAnalyzer;
import com.vader.sentiment.util.Utils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class TextProperties {
    private String inputText;
    private List<String> wordsAndEmoticons;
    private List<String> wordsOnly;
    private boolean isCapDiff;

    public TextProperties(String inputText) throws IOException {
        this.inputText = inputText;
        this.setWordsAndEmoticons();
        this.setCapDiff(this.isAllCapDifferential());
    }

    private void setWordsAndEmoticons() throws IOException {
        this.setWordsOnly();
        List<String> wordsAndEmoticonsList = new InputAnalyzer().defaultSplit(this.inputText);
        for (String currentWord : this.wordsOnly) {
            for (String currentPunc : Utils.PUNCTUATION_LIST) {
                String wordPunct = currentWord + currentPunc;
                Integer wordPunctCount = Collections.frequency(wordsAndEmoticonsList, wordPunct);
                while (wordPunctCount > 0) {
                    int index = wordsAndEmoticonsList.indexOf(wordPunct);
                    wordsAndEmoticonsList.remove(wordPunct);
                    wordsAndEmoticonsList.add(index, currentWord);
                    wordPunctCount = Collections.frequency(wordsAndEmoticonsList, wordPunct);
                }
                String punctWord = currentPunc + currentWord;
                Integer punctWordCount = Collections.frequency(wordsAndEmoticonsList, punctWord);
                while (punctWordCount > 0) {
                    int index = wordsAndEmoticonsList.indexOf(punctWord);
                    wordsAndEmoticonsList.remove(punctWord);
                    wordsAndEmoticonsList.add(index, currentWord);
                    punctWordCount = Collections.frequency(wordsAndEmoticonsList, punctWord);
                }
            }
        }
        this.wordsAndEmoticons = wordsAndEmoticonsList;
    }

    private void setWordsOnly() throws IOException {
        this.wordsOnly = new InputAnalyzer().removePunctuation(this.inputText);
    }

    private void setCapDiff(boolean capDiff) {
        this.isCapDiff = capDiff;
    }

    public List<String> getWordsAndEmoticons() {
        return this.wordsAndEmoticons;
    }

    public List<String> getWordsOnly() {
        return this.wordsOnly;
    }

    public boolean isCapDiff() {
        return this.isCapDiff;
    }

    private boolean isAllCapDifferential() {
        int countAllCaps = 0;
        for (String token : this.wordsAndEmoticons) {
            if (!Utils.isUpper(token)) continue;
            ++countAllCaps;
        }
        int capDifferential = this.wordsAndEmoticons.size() - countAllCaps;
        return 0 < capDifferential && capDifferential < this.wordsAndEmoticons.size();
    }
}

