/*
 * Decompiled with CFR 0.152.
 */
package com.vader.sentiment.processor;

import com.vader.sentiment.processor.InputAnalyzerInterface;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.analysis.miscellaneous.LengthFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

class InputAnalyzer
implements InputAnalyzerInterface {
    InputAnalyzer() {
    }

    private List<String> tokenize(String inputString, boolean removePunctuation) throws IOException {
        StringReader reader = new StringReader(inputString);
        Object currentTokenizer = removePunctuation ? new StandardTokenizer() : new WhitespaceTokenizer();
        currentTokenizer.setReader((Reader)reader);
        LengthFilter tokenStream = new LengthFilter((TokenStream)currentTokenizer, 2, Integer.MAX_VALUE);
        CharTermAttribute charTermAttribute = (CharTermAttribute)tokenStream.addAttribute(CharTermAttribute.class);
        tokenStream.reset();
        ArrayList<String> tokenizedString = new ArrayList<String>();
        while (tokenStream.incrementToken()) {
            tokenizedString.add(charTermAttribute.toString());
        }
        tokenStream.end();
        tokenStream.close();
        return tokenizedString;
    }

    @Override
    public List<String> defaultSplit(String inputString) throws IOException {
        return this.tokenize(inputString, false);
    }

    @Override
    public List<String> removePunctuation(String inputString) throws IOException {
        return this.tokenize(inputString, true);
    }
}

