/*
 * Decompiled with CFR 0.152.
 */
package com.vader.sentiment.analyzer;

import com.vader.sentiment.processor.TextProperties;
import com.vader.sentiment.util.SentimentModifyingTokens;
import com.vader.sentiment.util.Utils;
import com.vader.sentiment.util.Valence;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class SentimentAnalyzer {
    private static Logger logger = Logger.getLogger(SentimentAnalyzer.class);
    private String inputString;
    private TextProperties inputStringProperties;
    private Map<String, Float> polarity;

    public SentimentAnalyzer() {
    }

    public SentimentAnalyzer(String inputString) throws IOException {
        this.inputString = inputString;
        this.setInputStringProperties();
    }

    public void setInputString(String inputString) {
        this.inputString = inputString;
    }

    public void setInputStringProperties() throws IOException {
        this.inputStringProperties = new TextProperties(this.inputString);
    }

    public Map<String, Float> getPolarity() {
        return this.polarity;
    }

    public void analyze() {
        this.polarity = this.getSentiment();
    }

    private float valenceModifier(String precedingToken, float currentValence) {
        float scalar = 0.0f;
        String precedingWordLower = precedingToken.toLowerCase();
        if (Utils.getBoosterDictionary().containsKey(precedingWordLower)) {
            scalar = Utils.getBoosterDictionary().get(precedingWordLower).floatValue();
            if (currentValence < 0.0f) {
                scalar = -scalar;
            }
            if (Utils.isUpper(precedingToken) && this.inputStringProperties.isCapDiff()) {
                scalar = currentValence > 0.0f ? (scalar += Valence.ALL_CAPS_FACTOR.getValue()) : (scalar -= Valence.ALL_CAPS_FACTOR.getValue());
            }
        }
        return scalar;
    }

    private float checkForNever(float currentValence, int distance, int currentItemPosition, int closeTokenIndex) {
        List<String> wordsAndEmoticons = this.inputStringProperties.getWordsAndEmoticons();
        float tempValence = currentValence;
        if (distance == 0) {
            if (this.isNegative(wordsAndEmoticons.get(closeTokenIndex))) {
                tempValence *= Valence.NEGATIVE_WORD_DAMPING_FACTOR.getValue();
            }
        } else if (distance == 1) {
            String wordAtDistanceTwoLeft = wordsAndEmoticons.get(currentItemPosition - 2);
            String wordAtDistanceOneLeft = wordsAndEmoticons.get(currentItemPosition - 1);
            if (wordAtDistanceTwoLeft.equals(SentimentModifyingTokens.NEVER.getValue()) && (wordAtDistanceOneLeft.equals(SentimentModifyingTokens.SO.getValue()) || wordAtDistanceOneLeft.equals(SentimentModifyingTokens.NEVER.getValue()))) {
                tempValence *= Valence.PRECEDING_BIGRAM_HAVING_NEVER_DAMPING_FACTOR.getValue();
            } else if (this.isNegative(wordsAndEmoticons.get(closeTokenIndex))) {
                tempValence *= Valence.NEGATIVE_WORD_DAMPING_FACTOR.getValue();
            }
        } else if (distance == 2) {
            String wordAtDistanceThreeLeft = wordsAndEmoticons.get(currentItemPosition - 3);
            String wordAtDistanceTwoLeft = wordsAndEmoticons.get(currentItemPosition - 2);
            String wordAtDistanceOneLeft = wordsAndEmoticons.get(currentItemPosition - 1);
            if (wordAtDistanceThreeLeft.equals(SentimentModifyingTokens.NEVER.getValue()) && (wordAtDistanceTwoLeft.equals(SentimentModifyingTokens.SO.getValue()) || wordAtDistanceTwoLeft.equals(SentimentModifyingTokens.THIS.getValue())) || wordAtDistanceOneLeft.equals(SentimentModifyingTokens.SO.getValue()) || wordAtDistanceOneLeft.equals(SentimentModifyingTokens.THIS.getValue())) {
                tempValence *= Valence.PRECEDING_TRIGRAM_HAVING_NEVER_DAMPING_FACTOR.getValue();
            } else if (this.isNegative(wordsAndEmoticons.get(closeTokenIndex))) {
                tempValence *= Valence.NEGATIVE_WORD_DAMPING_FACTOR.getValue();
            }
        }
        return tempValence;
    }

    private float checkForIdioms(float currentValence, int currentItemPosition) {
        List<String> wordsAndEmoticons = this.inputStringProperties.getWordsAndEmoticons();
        String currentWord = wordsAndEmoticons.get(currentItemPosition);
        String oneWordLeftToCurrentWord = wordsAndEmoticons.get(currentItemPosition - 1);
        String twoWordsLeftToCurrentWord = wordsAndEmoticons.get(currentItemPosition - 2);
        String threeWordsLeftToCurrentWord = wordsAndEmoticons.get(currentItemPosition - 3);
        String bigramFormat = "%s %s";
        String trigramFormat = "%s %s %s";
        String leftBiGramFromCurrent = String.format("%s %s", oneWordLeftToCurrentWord, currentWord);
        String leftTriGramFromCurrent = String.format("%s %s %s", twoWordsLeftToCurrentWord, oneWordLeftToCurrentWord, currentWord);
        String leftBiGramFromOnePrevious = String.format("%s %s", twoWordsLeftToCurrentWord, oneWordLeftToCurrentWord);
        String leftTriGramFromOnePrevious = String.format("%s %s %s", threeWordsLeftToCurrentWord, twoWordsLeftToCurrentWord, oneWordLeftToCurrentWord);
        String leftBiGramFromTwoPrevious = String.format("%s %s", threeWordsLeftToCurrentWord, twoWordsLeftToCurrentWord);
        ArrayList<String> leftGramSequences = new ArrayList<String>();
        leftGramSequences.add(leftBiGramFromCurrent);
        leftGramSequences.add(leftTriGramFromCurrent);
        leftGramSequences.add(leftBiGramFromOnePrevious);
        leftGramSequences.add(leftTriGramFromOnePrevious);
        leftGramSequences.add(leftBiGramFromTwoPrevious);
        logger.debug((Object)("Grams: " + leftGramSequences));
        float tempValence = currentValence;
        for (String leftGramSequence : leftGramSequences) {
            if (!Utils.getSentimentLadenIdioms().containsKey(leftGramSequence)) continue;
            tempValence = Utils.getSentimentLadenIdioms().get(leftGramSequence).floatValue();
            break;
        }
        if (wordsAndEmoticons.size() - 1 > currentItemPosition) {
            String rightBiGramFromCurrent = String.format("%s %s", wordsAndEmoticons.get(currentItemPosition), wordsAndEmoticons.get(currentItemPosition + 1));
            if (Utils.getSentimentLadenIdioms().containsKey(rightBiGramFromCurrent)) {
                tempValence = Utils.getSentimentLadenIdioms().get(rightBiGramFromCurrent).floatValue();
            }
        }
        if (wordsAndEmoticons.size() - 1 > currentItemPosition + 1) {
            String rightTriGramFromCurrent = String.format("%s %s %s", wordsAndEmoticons.get(currentItemPosition), wordsAndEmoticons.get(currentItemPosition + 1), wordsAndEmoticons.get(currentItemPosition + 2));
            if (Utils.getSentimentLadenIdioms().containsKey(rightTriGramFromCurrent)) {
                tempValence = Utils.getSentimentLadenIdioms().get(rightTriGramFromCurrent).floatValue();
            }
        }
        if (Utils.getBoosterDictionary().containsKey(leftBiGramFromTwoPrevious) || Utils.getBoosterDictionary().containsKey(leftBiGramFromOnePrevious)) {
            tempValence += Valence.DEFAULT_DAMPING.getValue();
        }
        return tempValence;
    }

    private List<Float> getTokenWiseSentiment() {
        List<Float> sentiments = new ArrayList<Float>();
        List<String> wordsAndEmoticons = this.inputStringProperties.getWordsAndEmoticons();
        for (String currentItem : wordsAndEmoticons) {
            float currentValence = 0.0f;
            int currentItemPosition = wordsAndEmoticons.indexOf(currentItem);
            String currentItemLower = currentItem.toLowerCase();
            logger.debug((Object)("Current token, \"" + currentItem + "\" with index, i = " + currentItemPosition));
            logger.debug((Object)("Sentiment State before \"kind of\" processing: " + sentiments));
            if (currentItemPosition < wordsAndEmoticons.size() - 1 && currentItemLower.equals(SentimentModifyingTokens.KIND.getValue()) && wordsAndEmoticons.get(currentItemPosition + 1).toLowerCase().equals(SentimentModifyingTokens.OF.getValue()) || Utils.getBoosterDictionary().containsKey(currentItemLower)) {
                sentiments.add(Float.valueOf(currentValence));
                continue;
            }
            logger.debug((Object)("Sentiment State after \"kind of\" processing: " + sentiments));
            logger.debug((Object)String.format("Current Valence is %f for \"%s\"", Float.valueOf(currentValence), currentItem));
            if (Utils.getWordValenceDictionary().containsKey(currentItemLower)) {
                currentValence = Utils.getWordValenceDictionary().get(currentItemLower).floatValue();
                logger.debug((Object)("Current currentItem isUpper(): " + Utils.isUpper(currentItem)));
                logger.debug((Object)("Current currentItem isCapDiff(): " + this.inputStringProperties.isCapDiff()));
                if (Utils.isUpper(currentItem) && this.inputStringProperties.isCapDiff()) {
                    currentValence = (double)currentValence > 0.0 ? (currentValence += Valence.ALL_CAPS_FACTOR.getValue()) : (currentValence -= Valence.ALL_CAPS_FACTOR.getValue());
                }
                logger.debug((Object)String.format("Current Valence post all CAPS checks: %f", Float.valueOf(currentValence)));
                for (int distance = 0; distance < 3; ++distance) {
                    int closeTokenIndex = currentItemPosition - (distance + 1);
                    if (closeTokenIndex < 0) {
                        closeTokenIndex = this.inputStringProperties.getWordsAndEmoticons().size() - Math.abs(closeTokenIndex);
                    }
                    if (currentItemPosition <= distance || Utils.getWordValenceDictionary().containsKey(wordsAndEmoticons.get(closeTokenIndex).toLowerCase())) continue;
                    logger.debug((Object)String.format("Current Valence pre gramBasedValence: %f", Float.valueOf(currentValence)));
                    float gramBasedValence = this.valenceModifier(wordsAndEmoticons.get(closeTokenIndex), currentValence);
                    logger.debug((Object)String.format("Current Valence post gramBasedValence: %f", Float.valueOf(currentValence)));
                    if (gramBasedValence != 0.0f) {
                        if (distance == 1) {
                            gramBasedValence *= Valence.ONE_WORD_DISTANCE_DAMPING_FACTOR.getValue();
                        } else if (distance == 2) {
                            gramBasedValence *= Valence.TWO_WORD_DISTANCE_DAMPING_FACTOR.getValue();
                        }
                    }
                    logger.debug((Object)String.format("Current Valence post gramBasedValence and distance based damping: %f", Float.valueOf(currentValence += gramBasedValence)));
                    currentValence = this.checkForNever(currentValence, distance, currentItemPosition, closeTokenIndex);
                    logger.debug((Object)String.format("Current Valence post \"never\" check: %f", Float.valueOf(currentValence)));
                    if (distance != 2) continue;
                    currentValence = this.checkForIdioms(currentValence, currentItemPosition);
                    logger.debug((Object)String.format("Current Valence post Idiom check: %f", Float.valueOf(currentValence)));
                }
                currentValence = this.adjustIfHasAtLeast(currentItemPosition, wordsAndEmoticons, currentValence);
            }
            sentiments.add(Float.valueOf(currentValence));
        }
        logger.debug((Object)("Sentiment state after first pass through tokens: " + sentiments));
        sentiments = this.checkConjunctionBut(wordsAndEmoticons, sentiments);
        logger.debug((Object)("Sentiment state after checking conjunctions: " + sentiments));
        return sentiments;
    }

    private List<Float> siftSentimentScores(List<Float> tokenWiseSentimentState) {
        float positiveSentimentScore = 0.0f;
        float negativeSentimentScore = 0.0f;
        int neutralSentimentCount = 0;
        for (Float valence : tokenWiseSentimentState) {
            if (valence.floatValue() > 0.0f) {
                positiveSentimentScore += valence.floatValue() + 1.0f;
                continue;
            }
            if (valence.floatValue() < 0.0f) {
                negativeSentimentScore += valence.floatValue() - 1.0f;
                continue;
            }
            ++neutralSentimentCount;
        }
        return new ArrayList<Float>(Arrays.asList(Float.valueOf(positiveSentimentScore), Float.valueOf(negativeSentimentScore), Float.valueOf(neutralSentimentCount)));
    }

    private Map<String, Float> getPolarityScores(List<Float> tokenWiseSentimentState) {
        HashMap<String, Float> result = new HashMap<String, Float>();
        if (!tokenWiseSentimentState.isEmpty()) {
            float totalValence = 0.0f;
            for (Float valence : tokenWiseSentimentState) {
                totalValence += valence.floatValue();
            }
            logger.debug((Object)("Total valence: " + totalValence));
            float punctuationAmplifier = this.boostByPunctuation();
            if (totalValence > 0.0f) {
                totalValence += punctuationAmplifier;
            } else if (totalValence < 0.0f) {
                totalValence -= punctuationAmplifier;
            }
            logger.debug((Object)("Total valence after boost/damp by punctuation: " + totalValence));
            logger.debug((Object)("Final token-wise sentiment state: " + tokenWiseSentimentState));
            List<Float> siftedScores = this.siftSentimentScores(tokenWiseSentimentState);
            float positiveSentimentScore = siftedScores.get(0).floatValue();
            float negativeSentimentScore = siftedScores.get(1).floatValue();
            int neutralSentimentCount = Math.round(siftedScores.get(2).floatValue());
            logger.debug((Object)String.format("Post Sift Sentiment Scores: %s %s %s", Float.valueOf(positiveSentimentScore), Float.valueOf(negativeSentimentScore), neutralSentimentCount));
            if (positiveSentimentScore > Math.abs(negativeSentimentScore)) {
                positiveSentimentScore += punctuationAmplifier;
            } else if (positiveSentimentScore < Math.abs(negativeSentimentScore)) {
                negativeSentimentScore -= punctuationAmplifier;
            }
            float normalizationFactor = positiveSentimentScore + Math.abs(negativeSentimentScore) + (float)neutralSentimentCount;
            logger.debug((Object)("Normalization Factor: " + normalizationFactor));
            float compoundPolarity = this.normalizeScore(totalValence);
            logger.debug((Object)String.format("Pre-Normalized Scores: %s %s %s %s", Float.valueOf(Math.abs(positiveSentimentScore)), Float.valueOf(Math.abs(negativeSentimentScore)), Math.abs(neutralSentimentCount), Float.valueOf(compoundPolarity)));
            float absolutePositivePolarity = Math.abs(positiveSentimentScore / normalizationFactor);
            float absoluteNegativePolarity = Math.abs(negativeSentimentScore / normalizationFactor);
            float absoluteNeutralPolarity = Math.abs((float)neutralSentimentCount / normalizationFactor);
            logger.debug((Object)String.format("Pre-Round Scores: %s %s %s %s", Float.valueOf(absolutePositivePolarity), Float.valueOf(absoluteNegativePolarity), Float.valueOf(absoluteNeutralPolarity), Float.valueOf(compoundPolarity)));
            float normalizedPositivePolarity = SentimentAnalyzer.roundDecimal(absolutePositivePolarity, 3);
            float normalizedNegativePolarity = SentimentAnalyzer.roundDecimal(absoluteNegativePolarity, 3);
            float normalizedNeutralPolarity = SentimentAnalyzer.roundDecimal(absoluteNeutralPolarity, 3);
            float normalizedCompoundPolarity = SentimentAnalyzer.roundDecimal(compoundPolarity, 4);
            result.put("compound", Float.valueOf(normalizedCompoundPolarity));
            result.put("positive", Float.valueOf(normalizedPositivePolarity));
            result.put("negative", Float.valueOf(normalizedNegativePolarity));
            result.put("neutral", Float.valueOf(normalizedNeutralPolarity));
        } else {
            result.put("compound", Float.valueOf(0.0f));
            result.put("positive", Float.valueOf(0.0f));
            result.put("negative", Float.valueOf(0.0f));
            result.put("neutral", Float.valueOf(0.0f));
        }
        return result;
    }

    private float boostByPunctuation() {
        return this.boostByExclamation() + this.boostByQuestionMark();
    }

    private float boostByExclamation() {
        int exclamationCount = StringUtils.countMatches(this.inputString, SentimentModifyingTokens.EXCLAMATION_MARK.getValue());
        return (float)Math.min(exclamationCount, 4) * Valence.EXCLAMATION_BOOSTING.getValue();
    }

    private float boostByQuestionMark() {
        int questionMarkCount = StringUtils.countMatches(this.inputString, SentimentModifyingTokens.QUESTION_MARK.getValue());
        float questionMarkAmplifier = 0.0f;
        if (questionMarkCount > 1) {
            questionMarkAmplifier = questionMarkCount <= 3 ? (float)questionMarkCount * Valence.QUESTION_MARK_MAX_COUNT_BOOSTING.getValue() : Valence.QUESTION_MARK_BOOSTING.getValue();
        }
        return questionMarkAmplifier;
    }

    private List<Float> checkConjunctionBut(List<String> inputTokens, List<Float> tokenWiseSentimentState) {
        int indexOfConjunction = inputTokens.indexOf(SentimentModifyingTokens.BUT.getValue());
        if (indexOfConjunction < 0) {
            indexOfConjunction = inputTokens.indexOf(SentimentModifyingTokens.BUT.getValue().toUpperCase());
        }
        if (indexOfConjunction >= 0) {
            for (int valenceIndex = 0; valenceIndex < tokenWiseSentimentState.size(); ++valenceIndex) {
                float currentValence = tokenWiseSentimentState.get(valenceIndex).floatValue();
                if (valenceIndex < indexOfConjunction) {
                    currentValence *= Valence.PRE_CONJUNCTION_ADJUSTMENT_FACTOR.getValue();
                } else if (valenceIndex > indexOfConjunction) {
                    currentValence *= Valence.POST_CONJUNCTION_ADJUSTMENT_FACTOR.getValue();
                }
                tokenWiseSentimentState.set(valenceIndex, Float.valueOf(currentValence));
            }
        }
        return tokenWiseSentimentState;
    }

    private float adjustIfHasAtLeast(int currentItemPosition, List<String> wordsAndEmoticons, float currentValence) {
        float valence = currentValence;
        if (currentItemPosition > 1 && !Utils.getWordValenceDictionary().containsKey(wordsAndEmoticons.get(currentItemPosition - 1).toLowerCase()) && wordsAndEmoticons.get(currentItemPosition - 1).toLowerCase().equals(SentimentModifyingTokens.LEAST.getValue())) {
            if (!wordsAndEmoticons.get(currentItemPosition - 2).toLowerCase().equals(SentimentModifyingTokens.AT.getValue()) && !wordsAndEmoticons.get(currentItemPosition - 2).toLowerCase().equals(SentimentModifyingTokens.VERY.getValue())) {
                valence *= Valence.NEGATIVE_WORD_DAMPING_FACTOR.getValue();
            }
        } else if (currentItemPosition > 0 && !Utils.getWordValenceDictionary().containsKey(wordsAndEmoticons.get(currentItemPosition - 1).toLowerCase()) && wordsAndEmoticons.get(currentItemPosition - 1).equals(SentimentModifyingTokens.LEAST.getValue())) {
            valence *= Valence.NEGATIVE_WORD_DAMPING_FACTOR.getValue();
        }
        return valence;
    }

    private boolean hasContraction(String token) {
        return token.endsWith(SentimentModifyingTokens.CONTRACTION.getValue());
    }

    private boolean hasNegativeWord(String token, Set<String> newNegWords) {
        return newNegWords.contains(token);
    }

    private boolean isNegative(String token, boolean checkContractions) {
        boolean result = this.hasNegativeWord(token, Utils.NEGATIVE_WORDS);
        if (!checkContractions) {
            return result;
        }
        return result || this.hasContraction(token);
    }

    private boolean isNegative(String token) {
        return this.isNegative(token, true);
    }

    private float normalizeScore(float score, float alpha) {
        double normalizedScore = (double)score / Math.sqrt(score * score + alpha);
        return (float)normalizedScore;
    }

    private float normalizeScore(float score) {
        return this.normalizeScore(score, 15.0f);
    }

    private static float roundDecimal(float currentValue, int noOfPlaces) {
        float factor = (float)Math.pow(10.0, noOfPlaces);
        float number = Math.round(currentValue * factor);
        return number / factor;
    }

    private Map<String, Float> getSentiment() {
        List<Float> tokenWiseSentiments = this.getTokenWiseSentiment();
        return this.getPolarityScores(tokenWiseSentiments);
    }
}

