/*
 * Decompiled with CFR 0.152.
 */
package com.alogic.blob.service;

import com.alogic.blob.client.BlobTool;
import com.alogic.blob.core.BlobInfo;
import com.alogic.blob.core.BlobManager;
import com.alogic.blob.core.BlobWriter;
import com.anysoft.util.IOTools;
import com.anysoft.util.Properties;
import com.anysoft.util.PropertiesConstants;
import com.logicbus.backend.Context;
import com.logicbus.backend.Servant;
import com.logicbus.backend.ServantException;
import com.logicbus.backend.message.MultiPartForm;
import com.logicbus.models.servant.ServiceDescription;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;

public class Upload
extends Servant
implements MultiPartForm.FileItemHandler {
    protected byte[] buffer = null;

    public void create(ServiceDescription sd) {
        super.create(sd);
        Properties p = sd.getProperties();
        int bufferSize = PropertiesConstants.getInt((Properties)p, (String)"bufferSize", (int)10240, (boolean)true);
        this.buffer = new byte[bufferSize];
    }

    public int actionProcess(Context ctx) throws Exception {
        MultiPartForm msg = (MultiPartForm)ctx.asMessage(MultiPartForm.class);
        String domain = this.getArgument("domain", "default", ctx);
        BlobManager blobManager = BlobTool.getBlobManager(domain);
        if (blobManager == null) {
            throw new ServantException("core.blob_not_found", "Can not find a blob manager named: " + domain);
        }
        msg.handle(ctx, (Object)blobManager, (MultiPartForm.FileItemHandler)this);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Context ctx, Object cookies, FileItem item, Map<String, Object> result) {
        BlobManager blobManager = (BlobManager)cookies;
        BlobWriter writer = blobManager.newFile(item.getContentType());
        OutputStream out = writer.getOutputStream();
        InputStream in = null;
        try {
            in = item.getInputStream();
            try {
                int size = 0;
                while ((size = in.read(this.buffer)) != -1) {
                    out.write(this.buffer, 0, size);
                }
            }
            catch (Throwable throwable) {
                IOTools.close((Closeable[])new Closeable[]{in, out});
                throw throwable;
            }
            IOTools.close((Closeable[])new Closeable[]{in, out});
            BlobInfo info = writer.getBlobInfo();
            result.put("fileId", info.id());
            result.put("contentType", info.contentType());
            result.put("md5", info.md5());
            result.put("sucessful", "true");
            blobManager.commit(writer);
        }
        catch (Exception ex) {
            logger.error("Error when handle file:" + item.getName(), (Throwable)ex);
            result.put("sucessful", "false");
            blobManager.cancel(writer);
        }
    }
}

