/*
 * Decompiled with CFR 0.152.
 */
package com.alogic.blob.service;

import com.alogic.blob.client.BlobTool;
import com.alogic.blob.core.BlobInfo;
import com.alogic.blob.core.BlobManager;
import com.alogic.blob.core.BlobReader;
import com.anysoft.util.IOTools;
import com.anysoft.util.Properties;
import com.anysoft.util.PropertiesConstants;
import com.logicbus.backend.Context;
import com.logicbus.backend.Normalizer;
import com.logicbus.backend.Servant;
import com.logicbus.backend.ServantException;
import com.logicbus.backend.message.Message;
import com.logicbus.models.catalog.Path;
import com.logicbus.models.servant.ServiceDescription;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;

public class Download
extends Servant {
    protected byte[] buffer = null;

    public void create(ServiceDescription sd) {
        super.create(sd);
        Properties p = sd.getProperties();
        int bufferSize = PropertiesConstants.getInt((Properties)p, (String)"bufferSize", (int)10240, (boolean)true);
        this.buffer = new byte[bufferSize];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int actionProcess(Context ctx) throws Exception {
        ctx.asMessage(BlobMessage.class);
        String fileId = this.getArgument("fileId", ctx);
        String domain = this.getArgument("domain", "default", ctx);
        BlobManager manager = BlobTool.getBlobManager(domain);
        if (manager == null) {
            throw new ServantException("core.blob_not_found", "Can not find a blob manager named " + domain);
        }
        BlobReader reader = manager.getFile(fileId);
        if (reader == null) {
            throw new ServantException("core.blob_not_found", "Can not find a blob file named " + fileId);
        }
        BlobInfo info = reader.getBlobInfo();
        ctx.setResponseContentType(info.contentType());
        InputStream in = reader.getInputStream(0L);
        OutputStream out = ctx.getOutputStream();
        try {
            int size = 0;
            while ((size = in.read(this.buffer)) != -1) {
                out.write(this.buffer, 0, size);
            }
        }
        catch (Throwable throwable) {
            IOTools.close((Closeable[])new Closeable[]{in});
            throw throwable;
        }
        IOTools.close((Closeable[])new Closeable[]{in});
        return 0;
    }

    private static boolean isNull(String value) {
        return value == null || value.length() <= 0;
    }

    private static int findPos(int start, String path) {
        int length = path.length();
        int found = -1;
        boolean inSlash = true;
        for (int i = start; i < length; ++i) {
            if (inSlash) {
                if (path.charAt(i) == '/') continue;
                inSlash = false;
                continue;
            }
            if (path.charAt(i) != '/') continue;
            found = i;
            break;
        }
        if (found < 0) {
            found = path.length();
        }
        return found;
    }

    private static int findStart(String path) {
        int found;
        int length = path.length();
        for (found = 0; found < length; ++found) {
            if (path.charAt(found) == '/') continue;
            return found;
        }
        return found;
    }

    private static String trimSlash(String str) {
        int length = str.length();
        int start = 0;
        for (int i = 0; i < length; ++i) {
            if (str.charAt(i) == '/') continue;
            start = i;
            break;
        }
        int end = length - 1;
        for (int i = length - 1; i >= 0; --i) {
            if (str.charAt(i) == '/') continue;
            end = i;
            break;
        }
        if (end > start) {
            return str.substring(start, end + 1);
        }
        return "";
    }

    public static class TheNormalizer
    implements Normalizer {
        protected String proxyServiceId = "/component/blob/Download";

        public TheNormalizer(Properties p) {
            this.proxyServiceId = PropertiesConstants.getString((Properties)p, (String)"normalizer.blob.id", (String)this.proxyServiceId);
        }

        public Path normalize(Context ctx, HttpServletRequest request) {
            String path = request.getPathInfo();
            String queryString = request.getQueryString();
            String domain = null;
            String fileId = null;
            if (path != null && path.length() > 0) {
                int start = Download.findStart(path);
                int pos = Download.findPos(start, path);
                domain = Download.trimSlash(path.substring(start, pos));
                fileId = pos >= path.length() - 1 ? null : Download.trimSlash(path.substring(pos + 1));
            }
            if (Download.isNull(fileId)) {
                if (!Download.isNull(domain)) {
                    ctx.SetValue("fileId", domain);
                    ctx.SetValue("domain", "default");
                }
            } else {
                if (!Download.isNull(domain)) {
                    ctx.SetValue("domain", domain);
                }
                ctx.SetValue("fileId", fileId);
            }
            if (!Download.isNull(queryString)) {
                ctx.SetValue("query", queryString);
            }
            return new Path(this.proxyServiceId);
        }
    }

    public static class BlobMessage
    implements Message {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void finish(Context ctx, boolean closeStream) {
            if (!"core.ok".equals(ctx.getReturnCode())) {
                throw new ServantException(ctx.getReturnCode(), ctx.getReason());
            }
            OutputStream out = null;
            try {
                out = ctx.getOutputStream();
                if (!closeStream) return;
            }
            catch (IOException e) {
                try {
                    logger.error("IO Exception", (Throwable)e);
                    if (!closeStream) return;
                }
                catch (Throwable throwable) {
                    if (!closeStream) throw throwable;
                    IOTools.close((Closeable[])new Closeable[]{out});
                    throw throwable;
                }
                IOTools.close((Closeable[])new Closeable[]{out});
                return;
            }
            IOTools.close((Closeable[])new Closeable[]{out});
            return;
        }

        public void init(Context ctx) {
        }

        public String getContentType() {
            return "unknown";
        }

        public long getContentLength() {
            return 0L;
        }
    }
}

