/*
 * Decompiled with CFR 0.152.
 */
package com.alogic.blob.service;

import com.alogic.blob.context.BlobManagerSource;
import com.alogic.blob.core.BlobManager;
import com.logicbus.backend.AbstractServant;
import com.logicbus.backend.Context;
import com.logicbus.backend.ServantException;
import com.logicbus.backend.message.JsonMessage;
import com.logicbus.backend.message.XMLMessage;
import com.logicbus.models.servant.ServiceDescription;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BlobFileList
extends AbstractServant {
    protected int onXml(Context ctx) {
        XMLMessage msg = (XMLMessage)ctx.asMessage(XMLMessage.class);
        String id = this.getArgument("id", ctx);
        Document doc = msg.getDocument();
        Element root = msg.getRoot();
        BlobManagerSource src = BlobManagerSource.get();
        BlobManager found = (BlobManager)src.get(id);
        if (found == null) {
            throw new ServantException("user.data_not_found", "Can not find the blob manager :" + id);
        }
        String cookies = this.getArgument("cookies", "", ctx);
        int limit = this.getLimit(ctx);
        ArrayList<String> ids = new ArrayList<String>();
        cookies = found.list(ids, cookies, limit);
        Element blob = doc.createElement("blob");
        blob.setAttribute("id", id);
        if (cookies != null) {
            blob.setAttribute("cookies", cookies);
        }
        blob.setAttribute("limit", String.valueOf(limit));
        if (!ids.isEmpty()) {
            for (String _id : ids) {
                Element elem = doc.createElement("file");
                elem.setAttribute("id", _id);
                blob.appendChild(elem);
            }
        }
        root.appendChild(blob);
        return 0;
    }

    private int getLimit(Context ctx) {
        String value = this.getArgument("limit", "100", ctx);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            return 100;
        }
    }

    protected int onJson(Context ctx) throws Exception {
        JsonMessage msg = (JsonMessage)ctx.asMessage(JsonMessage.class);
        String id = this.getArgument("id", ctx);
        BlobManagerSource src = BlobManagerSource.get();
        BlobManager found = (BlobManager)src.get(id);
        if (found == null) {
            throw new ServantException("user.data_not_found", "Can not find the blob manager :" + id);
        }
        String cookies = this.getArgument("cookies", "", ctx);
        int limit = this.getLimit(ctx);
        ArrayList<String> ids = new ArrayList<String>();
        cookies = found.list(ids, cookies, limit);
        HashMap<String, Object> _blob = new HashMap<String, Object>();
        _blob.put("file", ids);
        _blob.put("id", id);
        if (cookies != null) {
            _blob.put("cookies", cookies);
        }
        _blob.put("limit", limit);
        msg.getRoot().put("blob", _blob);
        return 0;
    }

    protected void onDestroy() {
    }

    protected void onCreate(ServiceDescription sd) {
    }
}

