/*
 * Decompiled with CFR 0.152.
 */
package com.alogic.blob.resource;

import com.alogic.blob.core.BlobManager;
import com.alogic.blob.core.BlobReader;
import com.alogic.blob.core.BlobWriter;
import com.alogic.blob.resource.ResourceBlobInfo;
import com.alogic.blob.resource.ResourceBlobReader;
import com.anysoft.util.BaseException;
import com.anysoft.util.IOTools;
import com.anysoft.util.Properties;
import com.anysoft.util.PropertiesConstants;
import com.anysoft.util.Settings;
import com.anysoft.util.XmlElementProperties;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.w3c.dom.Element;

public class ResourceBlobManager
extends BlobManager.Abstract {
    private Map<String, ResourceBlobInfo> blobs = new ConcurrentHashMap<String, ResourceBlobInfo>();
    private String home = "";
    private Class<?> bootstrap = this.getClass();
    private String contentType = "image/*";

    public String getHome() {
        return this.home;
    }

    public Class<?> getBootstrap() {
        return this.bootstrap;
    }

    public String getContentType() {
        return this.contentType;
    }

    @Override
    public void configure(Element pElement, Properties pProps) {
        XmlElementProperties p = new XmlElementProperties(pElement, pProps);
        this.configure((Properties)p);
    }

    @Override
    public void configure(Properties p) {
        super.configure(p);
        this.contentType = PropertiesConstants.getString((Properties)p, (String)"contentType", (String)this.contentType, (boolean)true);
        this.home = PropertiesConstants.getString((Properties)p, (String)"home", (String)"", (boolean)true);
        String clazz = PropertiesConstants.getString((Properties)p, (String)"bootstrap", (String)"", (boolean)true);
        if (clazz != null && clazz.length() > 0) {
            ClassLoader cl = Settings.getClassLoader();
            try {
                this.bootstrap = cl.loadClass(clazz);
            }
            catch (Exception ex) {
                logger.error("Can not load class:" + clazz, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resourceFound(String h, String id) {
        InputStream in;
        block5: {
            in = null;
            String path = h + "/" + id;
            try {
                in = this.bootstrap.getResourceAsStream(path);
                if (in != null) {
                    String md5 = DigestUtils.md5Hex((InputStream)in);
                    ResourceBlobInfo info = new ResourceBlobInfo(id, this.contentType, md5, 0L, path);
                    this.blobs.put(id, info);
                    break block5;
                }
                logger.error("The resource is not valid :" + path);
            }
            catch (Exception ex) {
                try {
                    logger.error("Failed to build resource:" + id, (Throwable)ex);
                }
                catch (Throwable throwable) {
                    IOTools.close((Closeable[])new Closeable[]{in});
                    throw throwable;
                }
                IOTools.close((Closeable[])new Closeable[]{in});
            }
        }
        IOTools.close((Closeable[])new Closeable[]{in});
    }

    @Override
    public void report(Element xml) {
        if (xml != null) {
            super.report(xml);
            xml.setAttribute("home", this.home);
            xml.setAttribute("bootstrap", this.bootstrap.getName());
            xml.setAttribute("contentType", this.contentType);
            xml.setAttribute("count", String.valueOf(this.blobs.size()));
        }
    }

    @Override
    public void report(Map<String, Object> json) {
        if (json != null) {
            super.report(json);
            json.put("home", this.home);
            json.put("bootstrap", this.bootstrap.getName());
            json.put("contentType", this.contentType);
            json.put("count", this.blobs.size());
        }
    }

    @Override
    public BlobWriter newFile(String contentType) {
        throw new BaseException("core.not_supported", "This function is not suppurted yet.");
    }

    @Override
    public BlobReader getFile(String id) {
        ResourceBlobInfo found = this.blobs.get(id);
        return found == null ? null : new ResourceBlobReader(found, this.bootstrap);
    }

    @Override
    public boolean existFile(String id) {
        return this.blobs.containsKey(id);
    }

    @Override
    public boolean deleteFile(String id) {
        throw new BaseException("core.not_supported", "This function is not suppurted yet.");
    }

    @Override
    public void commit(BlobWriter writer) {
        throw new BaseException("core.not_supported", "This function is not suppurted yet.");
    }

    @Override
    public void cancel(BlobWriter writer) {
        throw new BaseException("core.not_supported", "This function is not suppurted yet.");
    }

    @Override
    public String list(List<String> ids, String cookies, int limit) {
        Iterator<String> keys = this.blobs.keySet().iterator();
        while (keys.hasNext()) {
            ids.add(keys.next());
        }
        return cookies;
    }
}

