/*
 * Decompiled with CFR 0.152.
 */
package com.alogic.blob.resource;

import com.alogic.blob.core.BlobManager;
import com.alogic.blob.core.BlobReader;
import com.alogic.blob.core.BlobWriter;
import com.alogic.blob.resource.ResourceBlobInfo;
import com.alogic.blob.resource.ResourceBlobReader;
import com.anysoft.util.BaseException;
import com.anysoft.util.IOTools;
import com.anysoft.util.Properties;
import com.anysoft.util.PropertiesConstants;
import com.anysoft.util.Settings;
import com.anysoft.util.XmlElementProperties;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.codec.digest.DigestUtils;
import org.w3c.dom.Element;

public class AutoIconSet
extends BlobManager.Abstract {
    private String home = "";
    private Class<?> bootstrap = this.getClass();
    private String contentType = "image/*";
    private List<ResourceBlobInfo> blobs = new ArrayList<ResourceBlobInfo>();

    public String getHome() {
        return this.home;
    }

    public Class<?> getBootstrap() {
        return this.bootstrap;
    }

    public String getContentType() {
        return this.contentType;
    }

    @Override
    public void configure(Element pElement, Properties pProps) {
        XmlElementProperties p = new XmlElementProperties(pElement, pProps);
        this.configure((Properties)p);
    }

    @Override
    public void configure(Properties p) {
        super.configure(p);
        this.contentType = PropertiesConstants.getString((Properties)p, (String)"contentType", (String)this.contentType, (boolean)true);
        this.home = PropertiesConstants.getString((Properties)p, (String)"home", (String)"/com/alogic/blob/icon/auto", (boolean)true);
        String clazz = PropertiesConstants.getString((Properties)p, (String)"bootstrap", (String)"", (boolean)true);
        if (clazz != null && clazz.length() > 0) {
            ClassLoader cl = Settings.getClassLoader();
            try {
                this.bootstrap = cl.loadClass(clazz);
            }
            catch (Exception ex) {
                logger.error("Can not load class:" + clazz, (Throwable)ex);
            }
        }
        this.scanResource(this.home, this.bootstrap);
    }

    protected void scanResource(String pHome, Class<?> pBootstrap) {
        URL url = pBootstrap.getResource(pHome);
        if (url.toString().startsWith("file:")) {
            File file;
            try {
                file = new File(url.toURI());
            }
            catch (URISyntaxException e) {
                logger.error("Can not scan home:" + pHome, (Throwable)e);
                return;
            }
            this.scanFileSystem(pHome, file);
        } else if (url.toString().startsWith("jar:")) {
            JarFile jfile;
            try {
                String jarUrl = url.toString();
                jarUrl = jarUrl.substring(9, jarUrl.indexOf(33));
                jfile = new JarFile(jarUrl);
            }
            catch (IOException e) {
                logger.error("Can not scan home:" + pHome, (Throwable)e);
                return;
            }
            this.scanJar(pHome, jfile);
        }
    }

    protected void scanJar(String home, JarFile pFile) {
        Enumeration<JarEntry> files = pFile.entries();
        while (files.hasMoreElements()) {
            JarEntry entry = files.nextElement();
            String name = entry.getName();
            if (!name.startsWith(home.substring(1)) || !name.endsWith(".png") && !name.endsWith(".jpg")) continue;
            this.resourceFound('/' + name);
        }
    }

    protected void scanFileSystem(String pHome, File pFile) {
        File[] files;
        for (File item : files = pFile.listFiles()) {
            if (!item.getName().endsWith(".png") && !item.getName().endsWith(".jpg")) continue;
            this.resourceFound(pHome + "/" + item.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resourceFound(String path) {
        InputStream in;
        block5: {
            in = null;
            try {
                in = this.bootstrap.getResourceAsStream(path);
                if (in != null) {
                    String md5 = DigestUtils.md5Hex((InputStream)in);
                    ResourceBlobInfo info = new ResourceBlobInfo(this.id, this.contentType, md5, 0L, path);
                    this.blobs.add(info);
                    break block5;
                }
                logger.error("The resource is not valid :" + path);
            }
            catch (Exception ex) {
                try {
                    logger.error("Failed to build resource:" + this.id, (Throwable)ex);
                }
                catch (Throwable throwable) {
                    IOTools.close((Closeable[])new Closeable[]{in});
                    throw throwable;
                }
                IOTools.close((Closeable[])new Closeable[]{in});
            }
        }
        IOTools.close((Closeable[])new Closeable[]{in});
    }

    @Override
    public void report(Element xml) {
        if (xml != null) {
            super.report(xml);
            xml.setAttribute("home", this.home);
            xml.setAttribute("bootstrap", this.bootstrap.getName());
            xml.setAttribute("contentType", this.contentType);
            xml.setAttribute("count", String.valueOf(this.blobs.size()));
        }
    }

    @Override
    public void report(Map<String, Object> json) {
        if (json != null) {
            super.report(json);
            json.put("home", this.home);
            json.put("bootstrap", this.bootstrap.getName());
            json.put("contentType", this.contentType);
            json.put("count", this.blobs.size());
        }
    }

    @Override
    public BlobReader getFile(String id) {
        if (this.blobs.isEmpty()) {
            return null;
        }
        int index = (id.hashCode() & Integer.MAX_VALUE) % this.blobs.size();
        return new ResourceBlobReader(this.blobs.get(index), this.bootstrap);
    }

    @Override
    public boolean existFile(String id) {
        return !this.blobs.isEmpty();
    }

    @Override
    public String list(List<String> ids, String cookies, int limit) {
        for (ResourceBlobInfo info : this.blobs) {
            ids.add(info.id());
        }
        return cookies;
    }

    @Override
    public BlobWriter newFile(String contentType) {
        throw new BaseException("core.not_supported", "This function is not suppurted yet.");
    }

    @Override
    public boolean deleteFile(String id) {
        throw new BaseException("core.not_supported", "This function is not suppurted yet.");
    }

    @Override
    public void commit(BlobWriter writer) {
        throw new BaseException("core.not_supported", "This function is not suppurted yet.");
    }

    @Override
    public void cancel(BlobWriter writer) {
        throw new BaseException("core.not_supported", "This function is not suppurted yet.");
    }
}

