/*
 * Decompiled with CFR 0.152.
 */
package com.alogic.blob.local;

import com.alogic.blob.core.BlobInfo;
import com.alogic.blob.core.BlobRegister;
import com.anysoft.util.Properties;
import com.anysoft.util.PropertiesConstants;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Random;
import org.w3c.dom.Element;

public class LocalFileRegister
extends BlobRegister.Abstract {
    protected String home = "${ketty.home}/blob/metadata/${id}";
    private static final char[] CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    protected static String readString(DataInputStream in) throws IOException {
        int length = in.readInt();
        byte[] bytes = new byte[length];
        in.read(bytes);
        return new String(bytes);
    }

    protected static long readLong(DataInputStream in) throws IOException {
        return in.readLong();
    }

    protected static void writeString(DataOutputStream out, String value) throws IOException {
        byte[] bytes = value.getBytes();
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    protected static void writeLong(DataOutputStream out, long value) throws IOException {
        out.writeLong(value);
    }

    @Override
    public BlobInfo find(String id) {
        File file = new File(this.getRealPath(id));
        if (file.exists() && file.canRead() && file.isFile()) {
            try {
                DataInputStream in = new DataInputStream(new FileInputStream(file));
                String contentType = LocalFileRegister.readString(in);
                String md5 = LocalFileRegister.readString(in);
                return new BlobInfo.Default(id, contentType, md5, file.length());
            }
            catch (FileNotFoundException e) {
                logger.error("Can not find file:" + file.getPath(), (Throwable)e);
            }
            catch (IOException e) {
                logger.error("Can not read file:" + file.getPath(), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void add(BlobInfo info) {
        File file = new File(this.getRealPath(info.id()));
        if (!file.exists()) {
            try {
                File parentFile = file.getParentFile();
                if (!parentFile.exists()) {
                    parentFile.mkdirs();
                }
                file.createNewFile();
                DataOutputStream out = new DataOutputStream(new FileOutputStream(file));
                LocalFileRegister.writeString(out, info.contentType());
                LocalFileRegister.writeString(out, info.md5());
            }
            catch (IOException e) {
                logger.error("Can not create new file:" + file.getPath(), (Throwable)e);
            }
        }
    }

    @Override
    public void delete(String id) {
        File file = new File(this.getRealPath(id));
        if (file.exists() && file.canWrite()) {
            file.delete();
        }
    }

    @Override
    public void configure(Properties p) {
        this.home = PropertiesConstants.getString((Properties)p, (String)"home.metadata", (String)this.home);
        File homeFile = new File(this.home);
        if (!homeFile.exists()) {
            homeFile.mkdirs();
        }
    }

    @Override
    public void report(Element xml) {
        if (xml != null) {
            super.report(xml);
            File file = new File(this.home);
            if (file.exists()) {
                xml.setAttribute("totalSpace", String.valueOf(file.getTotalSpace()));
                xml.setAttribute("usableSpace", String.valueOf(file.getUsableSpace()));
                xml.setAttribute("home", this.home);
            }
        }
    }

    @Override
    public void report(Map<String, Object> json) {
        if (json != null) {
            super.report(json);
            File file = new File(this.home);
            if (file.exists()) {
                json.put("totalSpace", file.getTotalSpace());
                json.put("usableSpace", file.getUsableSpace());
                json.put("home", this.home);
            }
        }
    }

    protected String getRealPath(String id) {
        long hash = (long)id.hashCode() & Long.MAX_VALUE;
        return this.home + File.separator + hash / 100L % 10L + File.separator + hash / 10L % 10L + File.separator + hash % 10L + File.separator + id + ".data";
    }

    protected String newFileId() {
        return System.currentTimeMillis() + LocalFileRegister.randomString(6);
    }

    protected static String randomString(int pWidth) {
        int width = pWidth <= 0 ? 6 : pWidth;
        char[] ret = new char[width];
        Random ran = new Random();
        for (int i = 0; i < width; ++i) {
            int intValue = ran.nextInt(62) % 62;
            ret[i] = CHARS[intValue];
        }
        return new String(ret);
    }
}

