/*
 * Decompiled with CFR 0.152.
 */
package com.alogic.blob.local;

import com.alogic.blob.core.BlobInfo;
import com.alogic.blob.core.BlobWriter;
import com.anysoft.util.IOTools;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalBlobWriter
implements BlobWriter {
    protected static final Logger logger = LoggerFactory.getLogger(BlobWriter.class);
    protected BlobInfo.Default info;
    protected File file;
    protected String id;

    public LocalBlobWriter(String pId, File pFile, String contentType) {
        this.id = pId;
        this.file = pFile;
        this.info = new BlobInfo.Default(this.id, contentType);
    }

    @Override
    public OutputStream getOutputStream() {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.file);
        }
        catch (FileNotFoundException e) {
            logger.error("Can not find file:" + this.file.getPath(), (Throwable)e);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public BlobInfo getBlobInfo() {
        String md5 = this.info.md5();
        if (md5 == null || md5.length() <= 0) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(this.file);
                this.info.md5(DigestUtils.md5Hex((InputStream)in));
                this.info.length(this.file.length());
            }
            catch (FileNotFoundException e) {
                logger.error("Can not find file:" + this.file.getPath(), (Throwable)e);
                IOTools.close((Closeable[])new Closeable[]{in});
            }
            catch (IOException e2) {
                logger.error("Can not read file:" + this.file.getPath(), (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        IOTools.close((Closeable[])new Closeable[]{in});
                        throw throwable;
                    }
                }
                IOTools.close((Closeable[])new Closeable[]{in});
            }
            IOTools.close((Closeable[])new Closeable[]{in});
        }
        return this.info;
    }
}

