/*
 * Decompiled with CFR 0.152.
 */
package com.alogic.blob.local;

import com.alogic.blob.core.BlobInfo;
import com.alogic.blob.core.BlobReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalBlobReader
implements BlobReader {
    protected static final Logger logger = LoggerFactory.getLogger(BlobReader.class);
    protected BlobInfo info = null;
    protected File file = null;
    protected String id;

    public LocalBlobReader(String pId, File pFile, BlobInfo pInfo) {
        this.id = pId;
        this.info = pInfo;
        this.file = pFile;
    }

    @Override
    public InputStream getInputStream(long offset) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.file);
            if (offset > 0L) {
                ((InputStream)in).skip(offset);
            }
        }
        catch (FileNotFoundException e) {
            logger.error("Can not find file:" + this.file.getPath(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Skip is not supported", (Throwable)e);
        }
        return in;
    }

    @Override
    public BlobInfo getBlobInfo() {
        return this.info;
    }
}

