/*
 * Decompiled with CFR 0.152.
 */
package com.alogic.blob.local;

import com.alogic.blob.core.BlobInfo;
import com.alogic.blob.core.BlobManager;
import com.alogic.blob.core.BlobReader;
import com.alogic.blob.core.BlobRegister;
import com.alogic.blob.core.BlobWriter;
import com.alogic.blob.local.LocalBlobReader;
import com.alogic.blob.local.LocalBlobWriter;
import com.alogic.blob.local.LocalFileRegister;
import com.anysoft.util.Factory;
import com.anysoft.util.Properties;
import com.anysoft.util.PropertiesConstants;
import com.anysoft.util.XmlElementProperties;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.w3c.dom.Element;

public class LocalBlobManager
extends BlobManager.Abstract {
    protected String home = "${ketty.home}/blob/data/${id}";
    protected BlobRegister fileRegister = null;
    private static final char[] CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    @Override
    public void report(Element xml) {
        if (xml != null) {
            super.report(xml);
            File file = new File(this.home);
            if (file.exists()) {
                xml.setAttribute("totalSpace", String.valueOf(file.getTotalSpace()));
                xml.setAttribute("usableSpace", String.valueOf(file.getUsableSpace()));
                xml.setAttribute("home", this.home);
            }
        }
    }

    @Override
    public void report(Map<String, Object> json) {
        if (json != null) {
            super.report(json);
            File file = new File(this.home);
            if (file.exists()) {
                json.put("totalSpace", file.getTotalSpace());
                json.put("usableSpace", file.getUsableSpace());
                json.put("home", this.home);
            }
        }
    }

    @Override
    public BlobWriter newFile(String contentType) {
        String fileId = this.newFileId();
        File file = new File(this.getRealPath(fileId));
        if (!file.exists()) {
            try {
                File parentFile = file.getParentFile();
                if (!parentFile.exists()) {
                    parentFile.mkdirs();
                }
                file.createNewFile();
                return new LocalBlobWriter(fileId, file, contentType);
            }
            catch (IOException e) {
                logger.error("Can not create new file:" + file.getPath(), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public BlobReader getFile(String id) {
        File file;
        BlobInfo info;
        BlobInfo blobInfo = info = this.fileRegister != null ? this.fileRegister.find(id) : null;
        if (info != null && (file = new File(this.getRealPath(id))).exists() && file.canRead() && file.isFile()) {
            return new LocalBlobReader(id, file, info);
        }
        return null;
    }

    @Override
    public boolean existFile(String id) {
        BlobInfo info;
        BlobInfo blobInfo = info = this.fileRegister != null ? this.fileRegister.find(id) : null;
        if (info != null) {
            File file = new File(this.getRealPath(id));
            return file.exists();
        }
        return false;
    }

    @Override
    public boolean deleteFile(String id) {
        this.fileRegister.delete(id);
        File file = new File(this.getRealPath(id));
        if (!file.exists() || !file.canWrite()) {
            return false;
        }
        return file.delete();
    }

    @Override
    public void configure(Properties p) {
        super.configure(p);
        this.id = PropertiesConstants.getString((Properties)p, (String)"id", (String)this.id);
        this.home = PropertiesConstants.getString((Properties)p, (String)"home.data", (String)this.home);
        File homeFile = new File(this.home);
        if (!homeFile.exists()) {
            homeFile.mkdirs();
        }
    }

    @Override
    public void configure(Element e, Properties props) {
        XmlElementProperties p = new XmlElementProperties(e, props);
        this.configure((Properties)p);
        Factory factory = new Factory();
        this.fileRegister = (BlobRegister)factory.newInstance(e, props, "register", LocalFileRegister.class.getName());
    }

    protected String getRealPath(String id) {
        long hash = (long)id.hashCode() & Long.MAX_VALUE;
        return this.home + File.separator + hash / 100L % 10L + File.separator + hash / 10L % 10L + File.separator + hash % 10L + File.separator + id + ".data";
    }

    protected String newFileId() {
        return System.currentTimeMillis() + LocalBlobManager.randomString(6);
    }

    protected static String randomString(int theWidth) {
        int width = theWidth <= 0 ? 6 : theWidth;
        char[] ret = new char[width];
        Random ran = new Random();
        for (int i = 0; i < width; ++i) {
            int intValue = ran.nextInt(62) % 62;
            ret[i] = CHARS[intValue];
        }
        return new String(ret);
    }

    @Override
    public void commit(BlobWriter writer) {
        if (this.fileRegister != null) {
            this.fileRegister.add(writer.getBlobInfo());
        }
    }

    @Override
    public void cancel(BlobWriter writer) {
        String fileId = writer.getBlobInfo().id();
        File file = new File(this.getRealPath(fileId));
        if (file.exists() && file.canWrite()) {
            file.delete();
        }
    }

    @Override
    public String list(List<String> ids, String cookies, int limit) {
        return this.fileRegister == null ? null : this.fileRegister.list(ids, cookies, limit);
    }
}

