/*
 * Decompiled with CFR 0.152.
 */
package com.alogic.blob.core;

import com.alogic.blob.core.BlobReader;
import com.alogic.blob.core.BlobWriter;
import com.anysoft.util.BaseException;
import com.anysoft.util.Configurable;
import com.anysoft.util.Properties;
import com.anysoft.util.PropertiesConstants;
import com.anysoft.util.Reportable;
import com.anysoft.util.XMLConfigurable;
import com.anysoft.util.XmlElementProperties;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public interface BlobManager
extends XMLConfigurable,
Configurable,
Reportable {
    public String getId();

    public BlobWriter newFile(String var1);

    public BlobReader getFile(String var1);

    public boolean existFile(String var1);

    public boolean deleteFile(String var1);

    public void commit(BlobWriter var1);

    public void cancel(BlobWriter var1);

    public String list(List<String> var1, String var2, int var3);

    public static abstract class Abstract
    implements BlobManager {
        protected static final Logger logger = LoggerFactory.getLogger(BlobManager.class);
        protected String id;

        @Override
        public String getId() {
            return this.id;
        }

        public void configure(Element e, Properties props) {
            XmlElementProperties p = new XmlElementProperties(e, props);
            this.configure((Properties)p);
        }

        public void configure(Properties p) {
            this.id = PropertiesConstants.getString((Properties)p, (String)"id", (String)this.id);
        }

        public void report(Element xml) {
            if (xml != null) {
                xml.setAttribute("module", this.getClass().getName());
                xml.setAttribute("id", this.getId());
            }
        }

        public void report(Map<String, Object> json) {
            if (json != null) {
                json.put("module", this.getClass().getName());
                json.put("id", this.getId());
            }
        }

        @Override
        public String list(List<String> ids, String cookies, int limit) {
            throw new BaseException("core.not_supported", "This function is not suppurted yet.");
        }
    }
}

