/*
 * Decompiled with CFR 0.152.
 */
package com.alogic.blob.core;

import com.anysoft.util.Reportable;
import java.util.Map;
import org.w3c.dom.Element;

public interface BlobInfo
extends Reportable {
    public String id();

    public String md5();

    public String contentType();

    public long length();

    public static class Default
    implements BlobInfo {
        protected String id;
        protected String contentType = "";
        protected String md5 = "";
        protected long length = 0L;

        public Default(String theId, String cType) {
            this.id = theId;
            this.contentType = cType == null ? "application/octet-stream" : cType;
        }

        public Default(String theId, String cType, String theMd5, long theLength) {
            this.id = theId;
            this.contentType = cType;
            this.md5 = theMd5;
            this.length = theLength;
        }

        public void report(Element xml) {
            if (xml != null) {
                xml.setAttribute("id", this.id);
                xml.setAttribute("contentType", this.contentType);
                xml.setAttribute("md5", this.md5);
                xml.setAttribute("length", String.valueOf(this.length));
            }
        }

        public void report(Map<String, Object> json) {
            if (json != null) {
                json.put("id", this.id);
                json.put("contentType", this.contentType);
                json.put("md5", this.md5);
                json.put("length", this.length);
            }
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public String md5() {
            return this.md5;
        }

        @Override
        public String contentType() {
            return this.contentType;
        }

        @Override
        public long length() {
            return this.length;
        }

        public void id(String theId) {
            this.id = theId;
        }

        public void md5(String theMd5) {
            this.md5 = theMd5;
        }

        public void contentType(String cType) {
            this.contentType = cType;
        }

        public void length(long theLength) {
            this.length = theLength;
        }
    }
}

