package com.github.antelopeframework.dynamicproperty.zk;

import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

import lombok.Setter;

@Setter
public class ZkConfigurationSourceFactoryBean implements FactoryBean<ZkConfigurationSource>, InitializingBean {
	private String configRootPath;
	private String connectionString;

	@Override
	public void afterPropertiesSet() throws Exception {
		Assert.hasText(configRootPath);
		Assert.hasText(connectionString);
	}
	
	@Override
	public ZkConfigurationSource getObject() throws Exception {
		CuratorFramework zkClient = CuratorFrameworkFactory.newClient(connectionString, new ExponentialBackoffRetry(1000, 3));
		zkClient.start();
		
		ZkConfigurationSource zkConfigSource = new ZkConfigurationSource(zkClient, configRootPath);
		zkConfigSource.start();
		
		return zkConfigSource;
	}

	@Override
	public Class<?> getObjectType() {
		return ZkConfigurationSource.class;
	}

	@Override
	public boolean isSingleton() {
		return true;
	}
}
