package com.github.antelopeframework.dynamicproperty.support;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

import com.github.antelopeframework.dynamicproperty.DynamicPropertyChangeListener;
import com.github.antelopeframework.dynamicproperty.spring.GlobalVars;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import lombok.Getter;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@Getter
@Setter
public class LogbackDynamicConfigurationHelper implements InitializingBean {
    public final static String LOGBACK_LOGGERS = "logback.loggers";
    
    private GlobalVars globalVars;
    
    @Override
    public void afterPropertiesSet() {
        GlobalVars.registDynamicPropertyListener(globalVars, LOGBACK_LOGGERS, new DynamicPropertyChangeListener() {
            @Override
            public void onUpdate(String value) {
                updateLogger(value);
            }
            
            @Override
            public void onDelete(String value) {
                
            }
        });
        
        updateLogger(globalVars.getValue(LOGBACK_LOGGERS));
    }
    
    public void updateLogger(String value) {
        if (log.isTraceEnabled()) {
            log.trace("dynamic config logback: value={}", value);
        }
        
        String[] loggers = StringUtils.split(value, "\n");
        if (loggers == null || loggers.length == 0) {
            return;
        }
        
        for (String one : loggers) {
            String[] parts = StringUtils.split(one, "=");
            if (parts == null || parts.length != 2) {
                continue;
            }
            
            try {
                Logger logger = (Logger) LoggerFactory.getLogger(parts[0].trim());
                logger.setLevel(Level.toLevel(parts[1].trim()));
            } catch (Exception e) {
                //DO-NOTHING
            }
        }
    }
}
