package com.github.antelopeframework.dynamicproperty.support;

import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;

import com.alibaba.fastjson.JSON;
import com.github.antelopeframework.dynamicproperty.ValueConverter;

public class JSONValueConverter implements ValueConverter {

	@Override
	@SuppressWarnings("unchecked")
	public <T> T convert(String value, Class<T> type) {
		if (StringUtils.isBlank(value)) {
            return null;
        }
        
		T result = null;
        if (ClassUtils.isPrimitiveOrWrapper(type)) {
            if (Boolean.class == type || Boolean.TYPE == type) {
                result = (T) Boolean.valueOf(value);
            } else if (Byte.class == type || Byte.TYPE == type) {
                result = (T) Byte.valueOf(value);
            } else if (Character.class == type || Character.TYPE == type) {
                result = (T) Character.valueOf(value.charAt(0));
            } else if (Short.class == type || Short.TYPE == type) {
                result = (T) Short.valueOf(value);
            } else if (Integer.class == type || Integer.TYPE == type) {
                result = (T) Integer.valueOf(value);
            } else if (Long.class == type || Long.TYPE == type) {
                result = (T) Long.valueOf(value);
            } else if (Double.class == type || Double.TYPE == type) {
                result = (T) Double.valueOf(value);
            } else if (Float.class == type || Float.TYPE == type) {
                result = (T) Float.valueOf(value);
            }
        } else {
            if (String.class.equals(type)) {
                result = (T) value;
            } else {
                result = JSON.parseObject(value, type);
            }
        }
        
		return result;
	}

}
