package com.github.antelopeframework.dynamicproperty.spring;

import java.util.Properties;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class PropertyPlaceholderConfigurer extends org.springframework.beans.factory.config.PropertyPlaceholderConfigurer {
    private Properties properties;
    
    public String resolvePlaceholder(String placeholder, Properties props, int systemPropertiesMode) {
        return super.resolvePlaceholder(placeholder, props, systemPropertiesMode);
    }
    
    @Override
    protected void processProperties(ConfigurableListableBeanFactory beanFactoryToProcess, Properties props) throws BeansException {
        this.properties = props;
        super.processProperties(beanFactoryToProcess, props);
    }
    
    public String getPlaceholderPrefix() {
        return placeholderPrefix;
    }
    
    public String getPlaceholderSuffix() {
        return placeholderSuffix;
    }
    
    public String getValueSeparator() {
        return valueSeparator;
    }
    
    public boolean getIgnoreUnresolvablePlaceholders() {
        return ignoreUnresolvablePlaceholders;
    }
    
    public String getNullValue() {
        return nullValue;
    }
    
    public Properties getProperties() {
        return this.properties;
    }
}
