package com.github.antelopeframework.dynamicproperty.spring;

import java.util.Formatter;
import java.util.Properties;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.PropertiesFactoryBean;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

/**
 * 将{@link PropertiesFactoryBean}加载的配置项输出出来, 用以检查环境是否正确配置.
 * 
 * @author yangzhi
 *
 */
@Slf4j
public class PropertiesPrinter implements InitializingBean {

	@Setter
	private Properties properties;

	@Override
	public void afterPropertiesSet() throws Exception {
	    String configedProperties = buildPropertiesLog("Configed Properties: ", properties);
	    String systemProperties = buildPropertiesLog("System Properties: ", properties);
	    
		System.out.println(configedProperties);
		log.trace(configedProperties);
		
		System.out.println(systemProperties);
		log.trace(systemProperties);
	}
	
	public String buildPropertiesLog(String prefix, Properties properties) {
	    Formatter formatter = new Formatter();
	    
	    StringBuilder sb = new StringBuilder();
	    sb.append("\n" + prefix + "\n");
	    
	    formatter.format("%32s %-16s\n", "-----key------", "--------value---------");
	    for (Object key : properties.keySet()) {
	        formatter.format("%32s %-16s\n", key, properties.getProperty(key.toString()));
	    }
	    
	    sb.append(formatter.toString());
	    formatter.close();
	    
	    return sb.toString();
	}
}
