package com.github.antelopeframework.dynamicproperty;

import java.util.Map;

/**
 * Can be used to set / retrieve Dynamic Properties.
 * 
 * Dynamic Properties are (String) values that can be automatically updated at
 * Runtime (on-the-fly).
 * 
 * Dynamic properties should be used for those kind of values that are possible
 * to change. If the property is being read only once, using a Dynamic Property
 * is pointless (the property could just be stored in a configuration file). //
 * *
 */
public interface DynamicPropertyManager {

    /**
     * Sets the current value of the specified {{propName}} to {{updatedValue}}
     * 
     * @param propName
     * @param updatedValue 
     */
    void updateValue(final String propName, final String updatedValue);

    
    Map<String, Object> getAllProperties();
    
    /**
     * @return the current value of the specified {{propName}}
     */
    String getCurrentValue(final String propName);

    /**
     * Subscribes for updates on the specified propName.
     */
    void addChangeListener(String propName, DynamicPropertyChangeListener listener);

    /**
     * Removes the listener.
     */
    void removeChangeListener(String propName, DynamicPropertyChangeListener listener);
}
