/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.util;

import com.adrninistrator.javacg.common.JavaCGCommonNameConstants;
import com.adrninistrator.javacg.dto.classes.ClassExtendsMethodInfo;
import com.adrninistrator.javacg.dto.classes.ClassImplementsMethodInfo;
import com.adrninistrator.javacg.dto.interfaces.InterfaceExtendsMethodInfo;
import com.adrninistrator.javacg.exceptions.JavaCGRuntimeException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class JavaCGUtil {
    public static boolean isInnerAnonymousClass(String className) {
        String tail = StringUtils.substringAfterLast((String)className, (String)"$");
        return JavaCGUtil.isNumStr(tail);
    }

    public static boolean isNumStr(String str) {
        char[] charArray;
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        for (char ch : charArray = str.toCharArray()) {
            if (ch >= '0' && ch <= '9') continue;
            return false;
        }
        return true;
    }

    public static InputStream cacheInputStream(InputStream inputStream) {
        try {
            int size;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] data = new byte[4096];
            while ((size = inputStream.read(data)) != -1) {
                baos.write(data, 0, size);
            }
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (Exception e) {
            System.err.println("\u51fa\u73b0\u5f02\u5e38 " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isObjectClass(String className) {
        return JavaCGCommonNameConstants.CLASS_NAME_OBJECT.equals(className);
    }

    public static boolean isClassInJdk(String className) {
        return StringUtils.startsWith((CharSequence)className, (CharSequence)"java.");
    }

    public static boolean isInitMethod(String methodName) {
        return "<init>".equals(methodName);
    }

    public static boolean isStringEndWithArrayIgnoreCase(String data, String[] array) {
        if (data == null || array == null || array.length == 0) {
            return false;
        }
        for (String arrayStr : array) {
            if (!StringUtils.endsWithIgnoreCase((CharSequence)data, (CharSequence)arrayStr)) continue;
            return true;
        }
        return false;
    }

    public static String getSimpleClassNameFromFull(String className) {
        int indexLastDot = className.lastIndexOf(".");
        if (indexLastDot == -1) {
            return className;
        }
        return className.substring(indexLastDot + 1);
    }

    public static String getFirstLetterLowerClassName(String simpleClassName) {
        if (simpleClassName == null) {
            return null;
        }
        if (simpleClassName.isEmpty()) {
            return "";
        }
        String firstLetterLower = simpleClassName.substring(0, 1).toLowerCase();
        if (simpleClassName.length() == 1) {
            return firstLetterLower;
        }
        return firstLetterLower + simpleClassName.substring(1);
    }

    public static String getPackageName(String className) {
        return StringUtils.substringBeforeLast((String)className, (String)".");
    }

    public static boolean checkSamePackage(String className1, String className2) {
        return StringUtils.equals((CharSequence)JavaCGUtil.getPackageName(className1), (CharSequence)JavaCGUtil.getPackageName(className2));
    }

    public static String currentTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HHmmss.SSS");
        return sdf.format(new Date());
    }

    public static boolean checkSkipClass(String className, Set<String> needHandlePackageSet) {
        if (JavaCGUtil.isCollectionEmpty(needHandlePackageSet)) {
            return false;
        }
        for (String needHandlePackage : needHandlePackageSet) {
            if (!StringUtils.startsWith((CharSequence)className, (CharSequence)needHandlePackage)) continue;
            return false;
        }
        return true;
    }

    public static String addSeparator4FilePath(String filePath) {
        if (StringUtils.endsWithAny((CharSequence)filePath, (CharSequence[])new CharSequence[]{"/", "\\"})) {
            return filePath;
        }
        return filePath + File.separator;
    }

    public static String getDirPathInJvmOptions(String jvmOptionKey) {
        String dirPath = System.getProperty(jvmOptionKey);
        if (dirPath == null) {
            return "";
        }
        return JavaCGUtil.addSeparator4FilePath(dirPath);
    }

    public static String base64Encode(String data) {
        return Base64.getEncoder().encodeToString(data.getBytes(StandardCharsets.UTF_8));
    }

    public static String base64Decode(String data) {
        return new String(Base64.getDecoder().decode(data), StandardCharsets.UTF_8);
    }

    public static <T> boolean isCollectionEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    @SafeVarargs
    public static <T> Set<T> genSetFromArray(T ... a) {
        if (ArrayUtils.isEmpty((Object[])a)) {
            return new HashSet();
        }
        return new HashSet<T>(Arrays.asList(a));
    }

    @SafeVarargs
    public static <T> List<T> genListFromArray(T ... a) {
        if (ArrayUtils.isEmpty((Object[])a)) {
            return new ArrayList();
        }
        return Arrays.asList(a);
    }

    public static boolean isChildOf(String childClassName, String superClassName, Map<String, ClassExtendsMethodInfo> classExtendsMethodInfoMap) {
        if (childClassName == null || superClassName == null || classExtendsMethodInfoMap == null) {
            throw new JavaCGRuntimeException("\u4f20\u5165\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        String currentClassName = childClassName;
        ClassExtendsMethodInfo classExtendsMethodInfo;
        while ((classExtendsMethodInfo = classExtendsMethodInfoMap.get(currentClassName)) != null) {
            if (superClassName.equals(classExtendsMethodInfo.getSuperClassName())) {
                return true;
            }
            currentClassName = classExtendsMethodInfo.getSuperClassName();
        }
        return false;
    }

    public static boolean isImplementationOf(String className, String interfaceName, Map<String, ClassExtendsMethodInfo> classExtendsMethodInfoMap, Map<String, ClassImplementsMethodInfo> classImplementsMethodInfoMap, Map<String, InterfaceExtendsMethodInfo> interfaceExtendsMethodInfoMap) {
        if (className == null || interfaceName == null || classExtendsMethodInfoMap == null || classImplementsMethodInfoMap == null || interfaceExtendsMethodInfoMap == null) {
            throw new JavaCGRuntimeException("\u4f20\u5165\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        String currentClassName = className;
        while (true) {
            ClassExtendsMethodInfo classExtendsMethodInfo;
            List<String> interfaceNameList;
            ClassImplementsMethodInfo classImplementsMethodInfo;
            if ((classImplementsMethodInfo = classImplementsMethodInfoMap.get(currentClassName)) != null && (interfaceNameList = classImplementsMethodInfo.getInterfaceNameList()) != null) {
                if (interfaceNameList.contains(interfaceName)) {
                    return true;
                }
                for (String currentInterfaceName : interfaceNameList) {
                    if (!JavaCGUtil.isSuperInterfaceOf(currentInterfaceName, interfaceName, interfaceExtendsMethodInfoMap)) continue;
                    return true;
                }
            }
            if ((classExtendsMethodInfo = classExtendsMethodInfoMap.get(currentClassName)) == null) {
                return false;
            }
            currentClassName = classExtendsMethodInfo.getSuperClassName();
        }
    }

    public static boolean isSuperInterfaceOf(String childInterfaceName, String superInterfaceName, Map<String, InterfaceExtendsMethodInfo> interfaceExtendsMethodInfoMap) {
        if (childInterfaceName == null || superInterfaceName == null || interfaceExtendsMethodInfoMap == null) {
            throw new JavaCGRuntimeException("\u4f20\u5165\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        InterfaceExtendsMethodInfo interfaceExtendsMethodInfo = interfaceExtendsMethodInfoMap.get(childInterfaceName);
        if (interfaceExtendsMethodInfo == null) {
            return false;
        }
        List<String> superInterfaceList = interfaceExtendsMethodInfo.getSuperInterfaceList();
        if (superInterfaceList.isEmpty()) {
            return false;
        }
        if (superInterfaceList.contains(superInterfaceName)) {
            return true;
        }
        for (String currentSuperInterfaceName : superInterfaceList) {
            if (!JavaCGUtil.isSuperInterfaceOf(currentSuperInterfaceName, superInterfaceName, interfaceExtendsMethodInfoMap)) continue;
            return true;
        }
        return false;
    }

    private JavaCGUtil() {
        throw new IllegalStateException("illegal");
    }
}

