/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.util;

import com.adrninistrator.javacg.util.JavaCGFileUtil;
import com.adrninistrator.javacg.util.JavaCGUtil;
import java.io.File;
import java.io.Writer;
import java.lang.management.ManagementFactory;

public class JavaCGLogUtil {
    private static boolean DEBUG_PRINT_FLAG = false;
    private static boolean DEBUG_PRINT_IN_FILE = false;
    public static Writer LOG_WRITER = null;
    private static boolean DEBUG_FLAG;

    public static boolean isDebugPrintFlag() {
        return DEBUG_PRINT_FLAG;
    }

    public static void setDebugPrintFlag(boolean debugPrintFlag) {
        if (DEBUG_PRINT_FLAG && !debugPrintFlag) {
            System.err.println("DEBUG_PRINT_FLAG\u5df2\u6253\u5f00\uff0c\u4e0d\u80fd\u518d\u5173\u95ed");
            return;
        }
        DEBUG_PRINT_FLAG = debugPrintFlag;
        if (DEBUG_PRINT_FLAG) {
            for (String arg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
                if (!arg.startsWith("-Xrunjdwp") && !arg.startsWith("-agentlib:jdwp")) continue;
                DEBUG_FLAG = true;
                break;
            }
        }
    }

    public static boolean isDebugPrintInFile() {
        return DEBUG_PRINT_IN_FILE;
    }

    public static void setDebugPrintInFile(boolean debugPrintInFile) {
        if (DEBUG_PRINT_IN_FILE && !debugPrintInFile) {
            System.err.println("DEBUG_PRINT_FLAG\u5df2\u6253\u5f00\uff0c\u4e0d\u80fd\u518d\u5173\u95ed");
            return;
        }
        DEBUG_PRINT_IN_FILE = debugPrintInFile;
        if (DEBUG_PRINT_IN_FILE) {
            JavaCGFileUtil.isDirectoryExists("log_javacg", true);
            String logPath = "log_javacg" + File.separator + "javacg-" + JavaCGUtil.currentTime() + ".log";
            System.out.println("\u5c06\u65e5\u5fd7\u5199\u5165\u6587\u4ef6\u4e2d " + logPath);
            try {
                LOG_WRITER = JavaCGFileUtil.genBufferedWriter(logPath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Runtime.getRuntime().addShutdownHook(new Thread(() -> JavaCGLogUtil.close()));
        }
    }

    public static boolean checkDebugFlag() {
        return DEBUG_FLAG;
    }

    public static void debugPrint(String data) {
        if (LOG_WRITER != null) {
            try {
                LOG_WRITER.write(data + "\n");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        System.out.println(data);
    }

    public static void close() {
        System.out.println(JavaCGLogUtil.class.getName() + ".close");
        if (LOG_WRITER != null) {
            try {
                LOG_WRITER.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private JavaCGLogUtil() {
        throw new IllegalStateException("illegal");
    }
}

