/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.javacg.util;

import com.adrninistrator.javacg.dto.counter.JavaCGCounter;
import com.adrninistrator.javacg.dto.jar.JarInfo;
import com.adrninistrator.javacg.util.JavaCGFileUtil;
import com.adrninistrator.javacg.util.JavaCGLogUtil;
import com.adrninistrator.javacg.util.JavaCGUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;

public class JavaCGJarUtil {
    private static Set<String> getMergeClassInJarPackageSet(Set<String> needHandlePackageSet) {
        if (JavaCGUtil.isCollectionEmpty(needHandlePackageSet)) {
            return new HashSet<String>();
        }
        HashSet<String> mergeClassInJarPackageSet = new HashSet<String>(needHandlePackageSet.size());
        System.out.println("\u5408\u5e76jar/war\u5305\u4e2d\u7684class\u6587\u4ef6\u65f6\uff0c\u9700\u8981\u5408\u5e76\u7684\u5305\u540d:");
        for (String mergeClassInJarPackage : needHandlePackageSet) {
            String newMergeClassInJarPackage;
            if (StringUtils.isBlank((CharSequence)mergeClassInJarPackage) || (newMergeClassInJarPackage = mergeClassInJarPackage.replace(".", "/")).startsWith("/") && StringUtils.isBlank((CharSequence)(newMergeClassInJarPackage = newMergeClassInJarPackage.substring(1)))) continue;
            if (!newMergeClassInJarPackage.endsWith("/")) {
                newMergeClassInJarPackage = newMergeClassInJarPackage + "/";
            }
            System.out.println(newMergeClassInJarPackage);
            mergeClassInJarPackageSet.add(newMergeClassInJarPackage);
        }
        return mergeClassInJarPackageSet;
    }

    public static File handleJar(List<String> jarOrDirPathList, Map<String, JarInfo> jarInfoMap, Set<String> needHandlePackageSet) {
        JavaCGCounter jarNumCounter = new JavaCGCounter(0);
        if (jarOrDirPathList.size() == 1) {
            File oneFile = new File(jarOrDirPathList.get(0));
            String oneFilePath = JavaCGFileUtil.getCanonicalPath(oneFile);
            if (!oneFile.exists()) {
                System.err.println("\u6307\u5b9a\u7684jar\u5305\u6216\u76ee\u5f55\u4e0d\u5b58\u5728: " + oneFilePath);
                return null;
            }
            if (oneFile.isFile()) {
                String oneFileNameLower = oneFile.getName().toLowerCase(Locale.ROOT);
                if (!StringUtils.endsWithAny((CharSequence)oneFileNameLower, (CharSequence[])new CharSequence[]{".jar", ".war"})) {
                    System.err.println("\u5904\u7406\u5355\u4e2a\u6587\u4ef6\u65f6\u53ea\u652f\u6301\u6307\u5b9a.jar\u6216.war\u683c\u5f0f\uff0c\u5047\u5982\u9700\u8981\u5904\u7406.class\u683c\u5f0f\u7684\u6587\u4ef6\uff0c\u5219\u9700\u8981\u6307\u5b9a\u5176\u6240\u5728\u76ee\u5f55");
                    return null;
                }
                jarInfoMap.put(oneFile.getName(), new JarInfo(jarNumCounter.addAndGet(), "J", oneFilePath));
                return oneFile;
            }
        }
        return JavaCGJarUtil.mergeJar(jarOrDirPathList, jarInfoMap, needHandlePackageSet, jarNumCounter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File mergeJar(List<String> jarOrDirPathList, Map<String, JarInfo> jarInfoMap, Set<String> needHandlePackageSet, JavaCGCounter jarNumCounter) {
        List<File> jarFileOrDirList = JavaCGJarUtil.getJarFileOrDirList(jarOrDirPathList, jarInfoMap, jarNumCounter);
        if (jarFileOrDirList == null) {
            return null;
        }
        File newJarFile = JavaCGJarUtil.getNewJarFile(jarFileOrDirList.get(0), jarOrDirPathList.get(0));
        if (newJarFile.exists()) {
            if (newJarFile.isDirectory()) {
                System.err.println("\u65b0\u7684jar\u5305\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u4f46\u662f\u662f\u76ee\u5f55: " + JavaCGFileUtil.getCanonicalPath(newJarFile));
                return null;
            }
            if (!JavaCGFileUtil.deleteFile(newJarFile)) {
                System.err.println("\u65b0\u7684jar\u5305\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u5220\u9664\u5931\u8d25: " + JavaCGFileUtil.getCanonicalPath(newJarFile));
                return null;
            }
        }
        HashSet<String> destJarDirNameSet = new HashSet<String>(jarOrDirPathList.size());
        ArrayList<File> jarFileInDirList = new ArrayList<File>();
        Set<String> mergeClassInJarPackageSet = JavaCGJarUtil.getMergeClassInJarPackageSet(needHandlePackageSet);
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(newJarFile));){
            for (File jarFileOrDir : jarFileOrDirList) {
                String jarFileOrDirName = jarFileOrDir.getName();
                if (destJarDirNameSet.contains(jarFileOrDirName)) {
                    System.err.println("\u6307\u5b9a\u7684jar/war\u5305\u6216\u76ee\u5f55\u5b58\u5728\u540c\u540d\uff0c\u4e0d\u5904\u7406: " + jarFileOrDirName + " " + JavaCGFileUtil.getCanonicalPath(jarFileOrDir));
                    continue;
                }
                destJarDirNameSet.add(jarFileOrDirName);
                if (jarFileOrDir.isFile()) {
                    JavaCGJarUtil.addJar2Jar(jarFileOrDir, zos, mergeClassInJarPackageSet);
                    continue;
                }
                JavaCGJarUtil.addDir2Jar(jarFileOrDir, jarFileInDirList, zos);
            }
            for (File jarFileInDir : jarFileInDirList) {
                String jarFileName = jarFileInDir.getName();
                String jarCanonicalPath = JavaCGFileUtil.getCanonicalPath(jarFileInDir);
                jarInfoMap.putIfAbsent(jarFileName, new JarInfo(jarNumCounter.addAndGet(), "J", jarCanonicalPath));
                if (destJarDirNameSet.contains(jarFileName)) {
                    System.err.println("\u6307\u5b9a\u7684jar\u5305\u6216\u76ee\u5f55\u5b58\u5728\u540c\u540d\uff0c\u4e0d\u5904\u7406: " + jarFileName + " " + jarCanonicalPath);
                    continue;
                }
                destJarDirNameSet.add(jarFileName);
                System.out.println("\u6dfb\u52a0\u76ee\u5f55\u4e2d\u7684jar/war\u5305: " + jarCanonicalPath);
                JavaCGJarUtil.addJar2Jar(jarFileInDir, zos, mergeClassInJarPackageSet);
            }
            File file = newJarFile;
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static List<File> getJarFileOrDirList(List<String> jarOrDirPathList, Map<String, JarInfo> jarInfoMap, JavaCGCounter jarNumCounter) {
        ArrayList<File> jarFileOrDirList = new ArrayList<File>(jarOrDirPathList.size());
        for (String currentJarOrDirPath : jarOrDirPathList) {
            File jarFileOrDir = new File(currentJarOrDirPath);
            String jarCanonicalPath = JavaCGFileUtil.getCanonicalPath(jarFileOrDir);
            if (!jarFileOrDir.exists()) {
                System.err.println("\u6307\u5b9a\u7684jar\u5305\u6216\u76ee\u5f55\u4e0d\u5b58\u5728: " + jarCanonicalPath);
                return null;
            }
            jarFileOrDirList.add(jarFileOrDir);
            String jarOrDirType = jarFileOrDir.isFile() ? "J" : "D";
            jarInfoMap.putIfAbsent(jarFileOrDir.getName(), new JarInfo(jarNumCounter.addAndGet(), jarOrDirType, jarCanonicalPath));
        }
        return jarFileOrDirList;
    }

    private static File getNewJarFile(File firstJarFile, String firstJarPath) {
        if (firstJarFile.isFile()) {
            return new File(firstJarPath + "-javacg_merged.jar");
        }
        return new File(firstJarPath + File.separator + firstJarFile.getName() + "-javacg_merged.jar");
    }

    private static void addJar2Jar(File sourceJarFile, ZipOutputStream targetZos, Set<String> mergeClassInJarPackageSet) throws IOException {
        String sourceJarName = sourceJarFile.getName();
        try (JarInputStream jarInputStream = new JarInputStream(new BufferedInputStream(new FileInputStream(sourceJarFile), 32768));){
            JarEntry jarEntry;
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                String jarEntryName;
                String jarEntryNameLower;
                if (jarEntry.isDirectory() || !(jarEntryNameLower = (jarEntryName = jarEntry.getName()).toLowerCase()).endsWith(".class") || JavaCGJarUtil.skipClassEntry(jarEntryName, mergeClassInJarPackageSet)) continue;
                ZipEntry newZipEntry = new ZipEntry(sourceJarName + "/" + jarEntryName);
                targetZos.putNextEntry(newZipEntry);
                JavaCGJarUtil.addInput2Jar(jarInputStream, targetZos);
            }
        }
    }

    private static boolean skipClassEntry(String jarEntryName, Set<String> mergeClassInJarPackageSet) {
        if (mergeClassInJarPackageSet.isEmpty()) {
            return false;
        }
        for (String mergeClassInJarPackage : mergeClassInJarPackageSet) {
            if (!jarEntryName.startsWith(mergeClassInJarPackage) && !jarEntryName.startsWith("WEB-INF/classes/" + mergeClassInJarPackage) && !jarEntryName.startsWith("BOOT-INF/classes/" + mergeClassInJarPackage)) continue;
            if (JavaCGLogUtil.isDebugPrintFlag()) {
                JavaCGLogUtil.debugPrint("\u5f53\u524dclass\u6587\u4ef6\u5305\u540d\u5339\u914d\uff0c\u9700\u8981\u5408\u5e76 " + jarEntryName + " " + mergeClassInJarPackage);
            }
            return false;
        }
        if (JavaCGLogUtil.isDebugPrintFlag()) {
            JavaCGLogUtil.debugPrint("\u5f53\u524dclass\u6587\u4ef6\u5305\u540d\u4e0d\u5339\u914d\uff0c\u4e0d\u5408\u5e76 " + jarEntryName);
        }
        return true;
    }

    private static void addDir2Jar(File sourceDirFile, List<File> jarFileInDirList, ZipOutputStream targetZos) throws IOException {
        ArrayList<File> nonJarFileList = new ArrayList<File>();
        ArrayList<String> nonJarFileRelativelyPathList = new ArrayList<String>();
        JavaCGJarUtil.findFileInSubDir(sourceDirFile, null, nonJarFileList, nonJarFileRelativelyPathList, jarFileInDirList);
        if (nonJarFileList.isEmpty()) {
            return;
        }
        for (int i = 0; i < nonJarFileList.size(); ++i) {
            ZipEntry newZipEntry = new ZipEntry((String)nonJarFileRelativelyPathList.get(i));
            targetZos.putNextEntry(newZipEntry);
            try (FileInputStream inputStream = new FileInputStream((File)nonJarFileList.get(i));){
                JavaCGJarUtil.addInput2Jar(inputStream, targetZos);
                continue;
            }
        }
    }

    private static void findFileInSubDir(File dirFile, String dirPath, List<File> nonJarFileList, List<String> fileRelativelyPathList, List<File> jarFileInDirList) {
        File[] files = dirFile.listFiles();
        if (files == null) {
            return;
        }
        String dirPathHeader = dirPath == null ? dirFile.getName() : dirPath + "/" + dirFile.getName();
        for (File file : files) {
            if (file.isDirectory()) {
                JavaCGJarUtil.findFileInSubDir(file, dirPathHeader, nonJarFileList, fileRelativelyPathList, jarFileInDirList);
                continue;
            }
            String currentFileName = file.getName();
            String currentFileNameLower = currentFileName.toLowerCase();
            if (currentFileNameLower.endsWith(".jar") || currentFileNameLower.endsWith(".war")) {
                if (currentFileName.endsWith("-javacg_merged.jar")) continue;
                jarFileInDirList.add(file);
                continue;
            }
            if (currentFileName.contains("-javacg_merged.jar")) continue;
            nonJarFileList.add(file);
            fileRelativelyPathList.add(dirPathHeader + "/" + currentFileNameLower);
        }
    }

    private static void addInput2Jar(InputStream inputStream, ZipOutputStream targetZos) throws IOException {
        int len;
        byte[] data = new byte[4096];
        while ((len = inputStream.read(data)) > 0) {
            targetZos.write(data, 0, len);
        }
    }

    private JavaCGJarUtil() {
        throw new IllegalStateException("illegal");
    }
}

